package com.testor.module.partner.model.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;
import java.util.Date;


/**
 * 现场作业_作业统计分析对象 t_job_accounting
 *
 * @author testor-framework
 * @date 2022-07-07 14:35:54
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_job_accounting")
@ApiModel(value = "TJobAccounting对象", description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TJobAccounting extends SuperModel {
    private static final long serialVersionUID = 1L;
    /**
     * 主键ID
     */
    @ApiModelProperty(value = "主键ID")

    @TableId("id")
    private String id;
    /**
     * 附件上传
     */
    @ApiModelProperty(value = "附件上传")

    @TableField("ref_id")
    private String refId;
    /**
     * 父级ID
     */
    @ApiModelProperty(value = "父级ID")

    @TableField("parent_id")
    private String parentId;
    /**
     * 租户id
     */
    @ApiModelProperty(value = "租户id")

    @TableField("tenant_id")
    private String tenantId;
    /**
     * 流程实例ID
     */
    @ApiModelProperty(value = "流程实例ID")

    @TableField("process_id")
    private String processId;
    /**
     * 流程状态
     */
    @ApiModelProperty(value = "流程状态")

    @TableField("process_status")
    private String processStatus;
    /**
     * 组织机构 id
     */
    @ApiModelProperty(value = " 组织机构 id（当前导入机构id-与名称无关联）")

    @TableField("org_id")
    private String orgId;

    @ApiModelProperty(value = "组织机构名称")

    @TableField("org_name")
    private String orgName;
    /**
     * 作业开始时间
     */
    @ApiModelProperty(value = "作业开始时间")

    @TableField("acc_start_date")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date accStartDate;
    /**
     * 相关方单位人数
     */
    @ApiModelProperty(value = "相关方单位人数", example = "0")

    @TableField("partner_population")
    private Integer partnerPopulation;
    /**
     * 危险作业类型
     */
    @ApiModelProperty(value = "危险作业类型")

    @TableField("acc_type")
    private String accType;
    /**
     * 租赁单位名称
     */
    @ApiModelProperty(value = "租赁单位名称")

    @TableField("lease_name")
    private String leaseName;
    /**
     * 是否为租赁单位（0-否；1-是）
     */
    @ApiModelProperty(value = "是否为租赁单位")

    @TableField("lease")
    private String lease;

    public static final String ID = "id";
    public static final String REF_ID = "ref_id";
    public static final String PARENT_ID = "parent_id";
    public static final String TENANT_ID = "tenant_id";
    public static final String PROCESS_ID = "process_id";
    public static final String PROCESS_STATUS = "process_status";
    public static final String ORG_ID = "org_id";
    public static final String ACC_START_DATE = "acc_start_date";
    public static final String PARTNER_POPULATION = "partner_population";
    public static final String ACC_TYPE = "acc_type";
    public static final String LEASE_NAME = "lease_name";
    public static final String LEASE = "lease";


}
