package com.testor.module.partner.model.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDate;
import java.util.Date;


/**
 * 相关方组织负责人对象 t_partner_org_res
 *
 * @author testor-framework
 * @date 2022-06-27 16:04:14
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_partner_org_res")
@ApiModel(value = "TPartnerOrgRes对象", description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TPartnerOrgRes extends SuperModel {
    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    @ApiModelProperty(value = "id")
    @TableId("id")
    private String id;

    /**
     * 组织机构id
     */
    @ApiModelProperty(value = "组织机构id")
    @TableField("org_id")
    private String orgId;

    /**
     * 类型id
     */
    @ApiModelProperty(value = "类型id")
    @TableField("type_id")
    private String typeId;

    /**
     * 相关方id
     */
    @ApiModelProperty(value = "相关方id")
    @TableField("partner_id")
    private String partnerId;

    /**
     * 现场负责人
     */
    @ApiModelProperty(value = "现场负责人")
    @TableField("responsible_person")
    private String responsiblePerson;

    /**
     * 联系方式
     */
    @ApiModelProperty(value = "联系方式")
    @TableField("phone")
    private String phone;

    /**
     * 合同日期
     */
    @ApiModelProperty(value = "合同日期")
    @TableField("contract_start_date")
    @JsonFormat(pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date contractStartDate;

    /**
     * 合同日期
     */
    @ApiModelProperty(value = "合同日期")
    @TableField("contract_end_date")
    @JsonFormat(pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date contractEndDate;

    /**
     * 租户id
     */
    @ApiModelProperty(value = "租户id")
    @TableField("tenant_id")
    private String tenantId;

    /**
     * 资质状态（0-异常，1-正常）
     */
    @ApiModelProperty(value = "资质状态（0-异常，1-正常）,默认1", example = "1")
    @TableField("certificate_status")
    private Integer certificateStatus = 1;

    public static final String ID = "id";
    public static final String ORG_ID = "org_id";
    public static final String TYPE_ID = "type_id";
    public static final String PARTNER_ID = "partner_id";
    public static final String RESPONSIBLE_PERSON = "responsible_person";
    public static final String PHONE = "phone";
    public static final String CONTRACT_START_DATE = "contract_start_date";
    public static final String CONTRACT_END_DATE = "contract_end_date";
    public static final String TENANT_ID = "tenant_id";
    public static final String CERTIFICATESTATUS = "certificate_status";


}
