package com.testor.module.partner.model.dto;

import com.testor.module.partner.model.domain.TPartnerStaff;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 相关方机构员工 删除参数对象
 *
 * @author testor-framework
 * @date 2022-06-01 14:18:06
 */

@Data
@ApiModel(value = "TPartnerStaff 列表查询参数对象")
@EqualsAndHashCode(callSuper = true)
public class TPartnerStaffParam extends TPartnerStaff {
	private static final long serialVersionUID = 1L;
	@ApiModelProperty(value = "每页数量")
	private String limit;

	@ApiModelProperty(value = "当前页数")
	private String page;

	@ApiModelProperty(value = "排序字段")
	private String orderBy;

	@ApiModelProperty(value = "排序方式")
	private String orderType;

	@ApiModelProperty(value = "企业选择")
	private List<String> condOrgIdList;

	@ApiModelProperty(value = "相关方机构名称")
	private String partnerName;

	@ApiModelProperty(value = "相关方机构ids")
	private List<String> ids;
}
