package com.testor.module.safe.task;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.testor.common.util.SpringBeanFactory;
import com.testor.module.messageNotice.model.domain.TMsgNotice;
import com.testor.module.messageNotice.model.vo.MsgTemplateVO;
import com.testor.module.messageNotice.service.TMsgNoticeService;
import org.flowable.engine.delegate.TaskListener;
import org.flowable.task.service.delegate.DelegateTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * TODO flowable task listener
 *
 * @author L
 * @version 1.0
 * @date 2022-08-22 18:23
 */
public class SafeTaskListener implements TaskListener {

    private static final Logger logger = LoggerFactory.getLogger(SafeTaskListener.class);

    private final TMsgNoticeService tMsgNoticeService;

    public SafeTaskListener() {
        this.tMsgNoticeService = SpringBeanFactory.getBean(TMsgNoticeService.class);
    }

    @Override
    public void notify(DelegateTask delegateTask) {
        logger.info("调用了监听,delegateTask:{}", JSONObject.toJSONString(delegateTask));
        // 返回此范围的本地变量
        Map<String, Object> variablesLocal = delegateTask.getVariablesLocal();
        // 节点名称
        String name = delegateTask.getName();
        // 消息类型
        String templateType = String.valueOf(variablesLocal.get("templateType"));
        // 隐患名称
        String safeName = String.valueOf(variablesLocal.get("name"));
        // 流程状态
        String processStatus = String.valueOf(variablesLocal.get("processStatus"));

        // 字典编码
        String bizKey = "hiddenDangerReport";
        // 对应业务值
        String bizKeyId = String.valueOf(variablesLocal.get("bizKeyId"));
        // 上报人
        String createBy = String.valueOf(variablesLocal.get("createBy"));
        // 整改人
        String rectifyPeople;

        MsgTemplateVO msgTemplateVO = new MsgTemplateVO();
        // 用户id，可批量
        List<String> userIdList = new ArrayList<>();
        switch (templateType) {
            case "assign":
                // 工单指派
                if ("2".equals(processStatus)) {
                    msgTemplateVO.setTemplateContent("您上报的隐患 [" + safeName + "] 已确定为隐患并指派给整改人。");
                } else if ("4".equals(processStatus)) {
                    msgTemplateVO.setTemplateContent("您上报的隐患 [" + safeName + "] 已确定为非隐患并关闭。");
                }
                userIdList.add(createBy);
                break;
            case "signForReceipt":
                // 工单签收   
                if ("6".equals(processStatus)) {
                    // 签收
                    msgTemplateVO.setTemplateContent("您指派的隐患 [" + safeName + "] 整改人已确认签收。");
                    // 给指派人发送消息
                    userIdList.add(createBy);
                }
                break;
            case "approval":
                // 原整改人
                String rectifyPeopleOriginal = String.valueOf(variablesLocal.get("rectifyPeopleOriginal"));

                // 转单审批
                if ("2".equals(processStatus)) {
                    // 签收
                    msgTemplateVO.setTemplateContent("您申请的排查工单 [" + safeName + "] 转单已通过审批。");
                    // 给转单申请人发送消息（原整改人）
                    userIdList.add(rectifyPeopleOriginal);
                }
                break;
            case "hiddenRectification":
                // 隐患整改
                // TODO 定时消息发送
                break;
            case "deferredApproval":
                // 延期审批
                rectifyPeople = String.valueOf(variablesLocal.get("rectifyPeople"));
                if ("6".equals(processStatus)) {
                    // 签收
                    msgTemplateVO.setTemplateContent("您申请的排查工单 [" + safeName + "] 整改延期已通过审批。");
                    // 给转延期申请人发送消息（整改人）
                    userIdList.add(rectifyPeople);
                }
                break;
            case "acceptance":
                // 整改验收
                rectifyPeople = String.valueOf(variablesLocal.get("rectifyPeople"));
                if ("9".equals(processStatus)) {
                    // 签收
                    msgTemplateVO.setTemplateContent("您整改的 [" + safeName + "] 隐患整改验收合格。");
                    // 给整改提交人发送消息（整改人）
                    userIdList.add(rectifyPeople);
                }
                break;
            case "superiorApproval":
                // 上级审批
                // 追责提交人
                String responsibleUserId = String.valueOf(variablesLocal.get("responsibleUserId"));
                if ("5".equals(processStatus)) {
                    // 签收
                    msgTemplateVO.setTemplateContent("您提交的 [" + safeName + "] 隐患排查治理反馈上级单位审批合格。");
                    // 给追责提交人发送消息（追责提交人）
                    userIdList.add(responsibleUserId);
                }
                break;
        }

        msgTemplateVO.setTemplateTypeName(name);
        msgTemplateVO.setTemplateType(templateType);
//        TMsgNoticeService tMsgNoticeService=new TMsgNoticeServiceImpl();
        List<TMsgNotice> tMsgNotices = tMsgNoticeService.generateMsgNotice(bizKey, bizKeyId, userIdList, msgTemplateVO);
        System.err.println(JSONArray.toJSONString(tMsgNotices));
        tMsgNoticeService.saveBatch(tMsgNotices);
    }
}
