package com.testor.module.safeCheck.controller;

import java.util.ArrayList;
import java.util.List;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import lombok.extern.slf4j.Slf4j;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RestController;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;

import com.testor.module.safeCheck.model.domain.TSafeHazardCheckResultType;
import com.testor.module.safeCheck.model.dto.TSafeHazardCheckResultTypeParam;
import com.testor.module.safeCheck.model.dto.TSafeHazardCheckResultTypeDelParam;
import com.testor.module.safeCheck.service.TSafeHazardCheckResultTypeService;

/**
 * 巡检结果类型配置Controller
 *
 * @author testor-framework
 * @date 2022-08-04 11:07:57
 */
@RestController
@RequestMapping("/safeCheck/checkResultType")
@Api(value = "TSafeHazardCheckResultType", tags = "巡检结果类型配置")
@Slf4j
public class TSafeHazardCheckResultTypeController extends SuperController
{
    @Autowired
    private TSafeHazardCheckResultTypeService tSafeHazardCheckResultTypeService;

    /* Generated Method*/
	@ApiOperation(value = "新增 巡检结果类型配置", notes = "Add TSafeHazardCheckResultType")
	@PostMapping(value = "/add")
	public BaseResponse<TSafeHazardCheckResultType>addEntity(@RequestBody TSafeHazardCheckResultType addRequest) {
		BaseResponse<TSafeHazardCheckResultType> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(addRequest)){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
			String id = IdHelper.getId32bit();
            TSafeHazardCheckResultType data=BeanHelper.beanToBean(addRequest,  TSafeHazardCheckResultType.class);
			data.setId(id);
			boolean result= tSafeHazardCheckResultTypeService.save(data);
			if(result){
                TSafeHazardCheckResultType newEntity = new TSafeHazardCheckResultType();
				newEntity.setId(id);
				baseResponse.setData(newEntity);
			}
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 巡检结果类型配置 ", notes = "Get TSafeHazardCheckResultType By Id")
	@GetMapping(value = "/get")
	public BaseResponse<TSafeHazardCheckResultType> getById(String id){
		BaseResponse<TSafeHazardCheckResultType> baseResponse=new BaseResponse<>();
		if(StringHelper.isNotEmpty(id)){
			// TODO 按需求添加业务异常判断
            TSafeHazardCheckResultType data= tSafeHazardCheckResultTypeService.getById(id);
			baseResponse.setData(data);
		}
		return baseResponse;
	}

	@ApiOperation(value = "修改 巡检结果类型配置 ", notes = "Update TSafeHazardCheckResultType By Id")
	@PutMapping(value = "/update")
	public BaseResponse<BizGeneralResponse> updateEntity(@RequestBody TSafeHazardCheckResultType updateRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(updateRequest)&&StringHelper.isNotEmpty(updateRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
            TSafeHazardCheckResultType data=BeanHelper.beanToBean(updateRequest, TSafeHazardCheckResultType.class);
			boolean result= tSafeHazardCheckResultTypeService.updateById(data);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "删除 巡检结果类型配置 ", notes = "delete TSafeHazardCheckResultType By Id")
	@PutMapping(value = "/delete")
	public BaseResponse<BizGeneralResponse> deleteEntity(@RequestBody TSafeHazardCheckResultTypeDelParam deleteRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(deleteRequest)&&StringHelper.isNotEmpty(deleteRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
            TSafeHazardCheckResultType data= new TSafeHazardCheckResultType();
			data.setId(deleteRequest.getId());
			data.setStatus(BizConstants.STATUS_DELETE);
			boolean result= tSafeHazardCheckResultTypeService.updateById(data);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "批量删除巡检结果类型配置", notes = "delete TSafeHazardCheckResultType by batch Id")
	@PutMapping(value = "/batch_delete")
	public BaseResponse<BizGeneralResponse> deleteEntityBatch(
			@RequestBody TSafeHazardCheckResultTypeDelParam deleteRequest) {
		BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
		if (ObjectHelper.isNotEmpty(deleteRequest) && (!deleteRequest.getIds().isEmpty())) {
            /* 批量删除 */
			List<TSafeHazardCheckResultType> tSafeHazardCheckResultTypeList = new ArrayList<>();
            for(String id: deleteRequest.getIds()){
                TSafeHazardCheckResultType data= new TSafeHazardCheckResultType();
				data.setId(id);
				data.setStatus(BizConstants.STATUS_DELETE);
                tSafeHazardCheckResultTypeList.add(data);
			}
			boolean result = tSafeHazardCheckResultTypeService.updateBatchById(tSafeHazardCheckResultTypeList);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 巡检结果类型配置 分页列表", notes = "List TSafeHazardCheckResultType with page")
	@GetMapping(value = "/list")
	public  BaseResponse<BaseResponseList<TSafeHazardCheckResultType>>listEntity(TSafeHazardCheckResultTypeParam param){
		BaseResponse<BaseResponseList<TSafeHazardCheckResultType>>baseResponse=new BaseResponse<>();
		Long page=
				StringHelper.isEmpty(param.getPage())?BizConstants.PAGE:Long.valueOf(param.getPage());
		Long limit=
				StringHelper.isEmpty(param.getLimit())?BizConstants.LIMIT:Long.valueOf(param.getLimit());
		Page<TSafeHazardCheckResultType> resultPage=new Page<>(page,limit);
		// TODO 根据需求修改查询条件及查询参数
		QueryWrapper<TSafeHazardCheckResultType> queryWrapper=this.createQuery(param);
		Page<TSafeHazardCheckResultType> resultList= tSafeHazardCheckResultTypeService.page(resultPage,queryWrapper);
		BaseResponseList<TSafeHazardCheckResultType> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList.getRecords());
		baseResponseList.setTotal(resultList.getTotal());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

	@ApiOperation(value = "获取 巡检结果类型配置 列表", notes = "List TSafeHazardCheckResultType all")
	@GetMapping(value = "/datas")
	public  BaseResponse<BaseResponseList<TSafeHazardCheckResultType>>listAllEntity(TSafeHazardCheckResultTypeParam param){
		BaseResponse<BaseResponseList<TSafeHazardCheckResultType>>baseResponse=new BaseResponse<>();
		// TODO 根据需求修改查询条件及查询参数
		QueryWrapper<TSafeHazardCheckResultType> queryWrapper=this.createQuery(param);
		List<TSafeHazardCheckResultType> resultList=tSafeHazardCheckResultTypeService.list(queryWrapper);
		BaseResponseList<TSafeHazardCheckResultType> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList);
		baseResponseList.setTotal(resultList.size());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

    /* Private Methods */
	/**
     * 列表查询条件及查询参数
     */
	private QueryWrapper<TSafeHazardCheckResultType> createQuery(TSafeHazardCheckResultTypeParam queryParam){
		QueryWrapper<TSafeHazardCheckResultType> queryWrapper=new QueryWrapper<>();
		if(StringHelper.isNotEmpty(queryParam.getName())){
			queryWrapper.like(TSafeHazardCheckResultType.NAME,queryParam.getName());
		}
		if(StringHelper.isNotEmpty(queryParam.getCode())){
			queryWrapper.eq(TSafeHazardCheckResultType.CODE,queryParam.getCode());
		}
		if(ObjectHelper.isNotEmpty(queryParam.getSort())){
			queryWrapper.eq(TSafeHazardCheckResultType.SORT,queryParam.getSort());
		}
		if(StringHelper.isNotEmpty(queryParam.getIsReport())){
			queryWrapper.eq(TSafeHazardCheckResultType.IS_REPORT,queryParam.getIsReport());
		}
		if (StringHelper.isNotEmpty(queryParam.getStatus())) {
			queryWrapper.eq(TSafeHazardCheckResultType.STATUS, queryParam.getStatus());
		} else {
			queryWrapper.ne(TSafeHazardCheckResultType.STATUS, BizConstants.STATUS_DELETE);
		}
		if (StringHelper.isNotEmpty(queryParam.getOrderBy())){
			if(StringHelper.isNotEmpty(queryParam.getOrderType())
					&&BizConstants.ASC.equals(queryParam.getOrderType())){
				queryWrapper.orderByAsc(queryParam.getOrderBy());
			}else{
				queryWrapper.orderByDesc(queryParam.getOrderBy());
			}
		}else{
			queryWrapper.orderByDesc(TSafeHazardCheckResultType.UPDATE_DATE);
		}
		return queryWrapper;
	}
}
