package com.testor.module.safeCheck.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.testor.module.safeCheck.model.domain.TSafeHazardCheckTask;
import com.testor.module.safeCheck.model.dto.TSafeHazardCheckTaskParam;
import com.testor.module.safeCheck.model.vo.SafeHazardCheckTaskListVO;
import com.testor.module.safeCheck.model.vo.SafeHazardCheckTaskVO;
import com.testor.module.safeCheck.service.TSafeHazardCheckTaskService;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * 巡检任务Controller
 *
 * @author testor-framework
 * @date 2022-08-04 11:07:59
 */
@RestController
@RequestMapping("/safeCheck/checkTask")
@Api(value = "TSafeHazardCheckTask", tags = "巡检任务")
@Slf4j
public class TSafeHazardCheckTaskController extends SuperController {
    @Autowired
    private TSafeHazardCheckTaskService tSafeHazardCheckTaskService;


    @ApiOperation(value = "获取 巡检任务 ", notes = "Get TSafeHazardCheckTask By Id")
    @GetMapping(value = "/get")
    public BaseResponse<SafeHazardCheckTaskVO> getById(String id) {
        BaseResponse<SafeHazardCheckTaskVO> baseResponse = new BaseResponse<>();
        if (StringHelper.isNotEmpty(id)) {
            SafeHazardCheckTaskVO data = tSafeHazardCheckTaskService.findById(id);
            baseResponse.setData(data);
        }
        return baseResponse;
    }


    @ApiOperation(value = "获取 巡检任务 分页列表", notes = "List checktask with page")
    @PostMapping(value = "/list")
    public BaseResponse<BaseResponseList<SafeHazardCheckTaskListVO>> listEntity(@RequestBody TSafeHazardCheckTaskParam param) {
        BaseResponse<BaseResponseList<SafeHazardCheckTaskListVO>> baseResponse = new BaseResponse<>();
        BaseResponseList<SafeHazardCheckTaskListVO> resultList = tSafeHazardCheckTaskService.listPage(param);
        baseResponse.setData(resultList);
        return baseResponse;
    }

    @ApiOperation(value = "提交完成巡检任务 ", notes = "delete TSafeHazardCheckResult By Id")
    @GetMapping(value = "/completeTask")
    public BaseResponse completeTask(@ApiParam("巡检任务id") @RequestParam("checkTaskId") String checkTaskId,
                                     @ApiParam("审批流程任务id") @RequestParam("taskId") String taskId) {
        BaseResponse baseResponse = tSafeHazardCheckTaskService.completeTask(checkTaskId, taskId);

        return baseResponse;
    }

    @ApiOperation(value = "测试创建任务（仅供测试使用，请勿调用） ", notes = "delete TSafeHazardCheckResult By Id")
    @GetMapping(value = "/testGenerateTask")
    public BaseResponse<TSafeHazardCheckTask> testGenerateTask(@RequestParam("checkPeopleId") String checkPeopleId) {
        BaseResponse baseResponse = new BaseResponse();
        TSafeHazardCheckTask tSafeHazardCheckTask = tSafeHazardCheckTaskService.generateCheckTask(checkPeopleId);
        baseResponse.setData(tSafeHazardCheckTask);
        return baseResponse;
    }



    /* Private Methods */

    /**
     * 列表查询条件及查询参数
     */
    private QueryWrapper<TSafeHazardCheckTask> createQuery(TSafeHazardCheckTaskParam queryParam) {
        QueryWrapper<TSafeHazardCheckTask> queryWrapper = new QueryWrapper<>();
        if (StringHelper.isNotEmpty(queryParam.getPlanId())) {
            queryWrapper.eq(TSafeHazardCheckTask.PLAN_ID, queryParam.getPlanId());
        }
        if (StringHelper.isNotEmpty(queryParam.getUserId())) {
            queryWrapper.eq(TSafeHazardCheckTask.USER_ID, queryParam.getUserId());
        }
        if (StringHelper.isNotEmpty(queryParam.getPeopleId())) {
            queryWrapper.eq(TSafeHazardCheckTask.PEOPLE_ID, queryParam.getPeopleId());
        }
        if (StringHelper.isNotEmpty(queryParam.getOrgId())) {
            queryWrapper.eq(TSafeHazardCheckTask.ORG_ID, queryParam.getOrgId());
        }
        if (StringHelper.isNotEmpty(queryParam.getCheckedOrgId())) {
            queryWrapper.eq(TSafeHazardCheckTask.CHECKED_ORG_ID, queryParam.getCheckedOrgId());
        }
        if (StringHelper.isNotEmpty(queryParam.getName())) {
            queryWrapper.like(TSafeHazardCheckTask.NAME, queryParam.getName());
        }
        if (StringHelper.isNotEmpty(queryParam.getCheckTypeId())) {
            queryWrapper.eq(TSafeHazardCheckTask.CHECK_TYPE_ID, queryParam.getCheckTypeId());
        }
        if (ObjectHelper.isNotEmpty(queryParam.getStartDate())) {
            queryWrapper.eq(TSafeHazardCheckTask.START_DATE, queryParam.getStartDate());
        }
        if (ObjectHelper.isNotEmpty(queryParam.getInitialEndDate())) {
            queryWrapper.eq(TSafeHazardCheckTask.INITIAL_END_DATE, queryParam.getInitialEndDate());
        }
        if (ObjectHelper.isNotEmpty(queryParam.getEndDate())) {
            queryWrapper.eq(TSafeHazardCheckTask.END_DATE, queryParam.getEndDate());
        }
        if (ObjectHelper.isNotEmpty(queryParam.getTaskStatus())) {
            queryWrapper.eq(TSafeHazardCheckTask.TASK_STATUS, queryParam.getTaskStatus());
        }
        if (StringHelper.isNotEmpty(queryParam.getIsOverdue())) {
            queryWrapper.eq(TSafeHazardCheckTask.IS_OVERDUE, queryParam.getIsOverdue());
        }
        if (ObjectHelper.isNotEmpty(queryParam.getCompleteDate())) {
            queryWrapper.eq(TSafeHazardCheckTask.COMPLETE_DATE, queryParam.getCompleteDate());
        }
        if (StringHelper.isNotEmpty(queryParam.getStatus())) {
            queryWrapper.eq(TSafeHazardCheckTask.STATUS, queryParam.getStatus());
        } else {
            queryWrapper.ne(TSafeHazardCheckTask.STATUS, BizConstants.STATUS_DELETE);
        }
        if (StringHelper.isNotEmpty(queryParam.getOrderBy())) {
            if (StringHelper.isNotEmpty(queryParam.getOrderType())
                    && BizConstants.ASC.equals(queryParam.getOrderType())) {
                queryWrapper.orderByAsc(queryParam.getOrderBy());
            } else {
                queryWrapper.orderByDesc(queryParam.getOrderBy());
            }
        } else {
            queryWrapper.orderByDesc(TSafeHazardCheckTask.UPDATE_DATE);
        }
        return queryWrapper;
    }
}
