package com.testor.module.safeCheck.service;


import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.module.safeCheck.model.domain.TSafeCheckPlan;
import com.testor.module.safeCheck.model.dto.TSafeCheckPlanParam;
import com.tongtech.tfw.backend.common.models.supers.SuperService;

import java.util.List;

/**
 * 安全检查计划Service接口
 * 
 * @author testor-framework
 * @date 2024-09-03 08:04:18
 */
public interface TSafeCheckPlanService extends SuperService<TSafeCheckPlan> {

    /**
     * 新增安全检查计划
     * @param data
     * @return
     */
    boolean add(TSafeCheckPlan data);

    /**
     * 修改安全检查计划
     * @param data
     * @return
     */
    boolean update(TSafeCheckPlan data);

    boolean copyPlan(TSafeCheckPlan updateRequest);

    List<TSafeCheckPlan> findList(TSafeCheckPlanParam param);

    List<TSafeCheckPlan> findOngoingList();

    Page<TSafeCheckPlan> pageList(TSafeCheckPlanParam param);

    public void delCheckOrgAndPerson(String planId);

}
