package com.testor.module.train.project.model.enums;

/**
 *
 * @author
 * @date 2024/9/6
 * @description  培训类型
 */
public enum TrainTypeEnum {

    /**
     *     教育培训_培训类型(train_type)
     *         新员工及转岗培训 4
     *         实操培训 3
     *         专项培训 2
     *         综合培训  1
     */
    P_M("1", "综合培训"),
    A_M("2", "专项培训"),
    B_M("3", "实操培训"),
    C_M("4", "新员工及转岗培训"),
    ;
    private String value;
    private String name;

    TrainTypeEnum(String value, String name) {
        this.value = value;
        this.name = name;
    }

    public String getValue() {
        return value;
    }

    public String getName() {
        return name;
    }

    public static String getName(String value) {
        for (TrainTypeEnum bean : TrainTypeEnum.values()) {
            if (bean.getValue().equals(value)) {
                return bean.getName();
            }
        }
        return value;
    }
}
