/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tfw.ureport.support;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.bstek.ureport.provider.report.ReportFile;
import com.bstek.ureport.provider.report.ReportProvider;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import com.tongtech.tfw.backend.common.request.RequestUtil;
import com.tongtech.tfw.ureport.model.domain.TUreportFile;
import com.tongtech.tfw.ureport.service.TUreportFileService;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Date;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="ureport.mysql.provider")
public class MySQLProvider
implements ReportProvider {
    private static final String NAME = "DB-Store";
    private String prefix = "mysql:";
    private boolean disabled;
    @Autowired
    private TUreportFileService tUreportFileService;

    public InputStream loadReport(String file) {
        TUreportFile ureportFileEntity = this.tUreportFileService.queryUreportFileByName(this.getCorrectName(file));
        return new ByteArrayInputStream(ureportFileEntity.getContent().getBytes());
    }

    public void deleteReport(String file) {
        this.tUreportFileService.deleteReportByName(this.getCorrectName(file));
    }

    public List<ReportFile> getReportFiles() {
        List list = this.tUreportFileService.list((Wrapper)new QueryWrapper().lambda().eq(SuperModel::getStatus, (Object)"0"));
        ArrayList<ReportFile> reportList = new ArrayList<ReportFile>();
        for (TUreportFile ureportFileEntity : list) {
            reportList.add(new ReportFile(ureportFileEntity.getName(), Date.from(ureportFileEntity.getUpdateDate().atZone(ZoneId.systemDefault()).toInstant())));
        }
        return reportList;
    }

    public void saveReport(String file, String content) {
        file = this.getCorrectName(file);
        TUreportFile ureportFileEntity = this.tUreportFileService.queryUreportFileByName(file);
        String userId = Optional.ofNullable((String)RequestUtil.getRequest().getAttribute("user_id")).orElse("test");
        if (ureportFileEntity == null) {
            ureportFileEntity = new TUreportFile();
            ureportFileEntity.setName(file);
            ureportFileEntity.setContent(content);
            ureportFileEntity.setCreateBy(userId);
            ureportFileEntity.setCreateDate(LocalDateTime.now());
            ureportFileEntity.setUpdateBy(userId);
            ureportFileEntity.setUpdateDate(LocalDateTime.now());
            ureportFileEntity.setStatus("0");
            ureportFileEntity.setIsPublish("0");
            this.tUreportFileService.save((Object)ureportFileEntity);
        } else {
            ureportFileEntity.setContent(content);
            ureportFileEntity.setUpdateBy(userId);
            ureportFileEntity.setUpdateDate(LocalDateTime.now());
            this.tUreportFileService.updateById((Object)ureportFileEntity);
        }
    }

    public String getName() {
        return NAME;
    }

    public boolean disabled() {
        return this.disabled;
    }

    public String getPrefix() {
        return this.prefix;
    }

    private String getCorrectName(String name) {
        if (name.startsWith(this.prefix)) {
            name = name.substring(this.prefix.length(), name.length());
        }
        return name;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public void setTUreportFileService(TUreportFileService tUreportFileService) {
        this.tUreportFileService = tUreportFileService;
    }
}

