/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tfw.workflow.apis.application.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.workflow.apis.application.model.dto.MyApplicationsListRequest;
import com.tongtech.tfw.workflow.apis.application.model.dto.MyApplicationsListResponse;
import com.tongtech.tfw.workflow.apis.definition.model.domain.ActReProcdef;
import com.tongtech.tfw.workflow.apis.definition.service.ActReProcdefService;
import com.tongtech.tfw.workflow.apis.instance.model.domain.ActHiProcinst;
import com.tongtech.tfw.workflow.apis.instance.service.ActHiProcinstService;
import com.tongtech.tfw.workflow.apis.user.service.ActIdUserService;
import com.tongtech.tfw.workflow.service.TfwCommonService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.runtime.ActivityInstance;
import org.flowable.engine.runtime.ActivityInstanceQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(value="WF Application Controller", tags={"WF\u6211\u7684\u7533\u8bf7\u7ba1\u7406"})
@RequestMapping(value={"/wf/application"})
public class ApplicationController
extends SuperController {
    private static final Logger log = LoggerFactory.getLogger(ApplicationController.class);
    @Autowired
    private ActHiProcinstService actHiProcinstService;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private ActIdUserService actIdUserService;
    @Autowired
    private TfwCommonService tfwCommonService;
    @Autowired
    private ActReProcdefService actReProcdefService;

    @ApiOperation(value="\u6211\u7684\u7533\u8bf7-\u5217\u8868", notes="List My Application")
    @GetMapping(value={"/my/list"})
    public BaseResponse<BaseResponseList<MyApplicationsListResponse>> processInsList(MyApplicationsListRequest processInsListRequest) {
        BaseResponse baseResponse = new BaseResponse();
        Long page = StringHelper.isEmpty((CharSequence)processInsListRequest.getPage()) ? BizConstants.PAGE : Long.valueOf(processInsListRequest.getPage());
        Long limit = StringHelper.isEmpty((CharSequence)processInsListRequest.getLimit()) ? BizConstants.LIMIT : Long.valueOf(processInsListRequest.getLimit());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"START_USER_ID_", (Object)this.getUserId());
        if (StringHelper.isNotBlank((CharSequence)processInsListRequest.getProcessDefinitionName())) {
            queryWrapper.in((Object)"PROC_DEF_ID_", this.tfwCommonService.queryDefId(processInsListRequest.getProcessDefinitionName()));
        }
        queryWrapper.orderByDesc((Object)"START_TIME_");
        Page resultPage = new Page(page.longValue(), limit.longValue());
        Page resultList = (Page)this.actHiProcinstService.page((IPage)resultPage, (Wrapper)queryWrapper);
        ArrayList<MyApplicationsListResponse> result = new ArrayList<MyApplicationsListResponse>(resultList.getRecords().size());
        for (ActHiProcinst actHiProcinst : resultList.getRecords()) {
            List actList;
            MyApplicationsListResponse myApplicationsListResponse = new MyApplicationsListResponse(actHiProcinst);
            myApplicationsListResponse.setStartUser(this.tfwCommonService.queryUserName(myApplicationsListResponse.getStartUser()));
            ActReProcdef actReProcdef = (ActReProcdef)this.actReProcdefService.getOne((Wrapper)new QueryWrapper().eq((Object)"ID_", (Object)actHiProcinst.getProcDefId()));
            myApplicationsListResponse.setProcessDefinitionName(actReProcdef.getName());
            myApplicationsListResponse.setProcessDefinitionDescription(actReProcdef.getDescription());
            if (ObjectHelper.isEmpty((Object)actHiProcinst.getEndTime()) && !(actList = ((ActivityInstanceQuery)this.runtimeService.createActivityInstanceQuery().processInstanceId(actHiProcinst.getProcInstId()).activityType("userTask").orderByActivityInstanceStartTime().desc()).list()).isEmpty()) {
                ActivityInstance activityInstance = (ActivityInstance)actList.get(0);
                myApplicationsListResponse.setExecutionId(activityInstance.getExecutionId());
                myApplicationsListResponse.setCurrentTaskName(activityInstance.getActivityName());
                if (StringHelper.isNotBlank((CharSequence)activityInstance.getAssignee())) {
                    myApplicationsListResponse.setAssigneeName(this.tfwCommonService.queryUserName(activityInstance.getAssignee()));
                }
            }
            result.add(myApplicationsListResponse);
        }
        BaseResponseList responseListBaseResponse = new BaseResponseList();
        responseListBaseResponse.setData(result);
        responseListBaseResponse.setTotal(resultList.getTotal());
        baseResponse.setData((Object)responseListBaseResponse);
        return baseResponse;
    }
}

