package com.testor.ddd.functionConfiguration.application.tableNum.impl;

import com.testor.ddd.functionConfiguration.application.tableNum.TableNumManageService;
import com.testor.ddd.functionConfiguration.domain.tableNum.entity.TTableNumRepo;
import com.testor.ddd.functionConfiguration.domain.tableNum.service.TableNumService;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;

@Service
public class TableNumManageServiceImpl implements TableNumManageService {

    @Resource
    private TableNumService tableNumService;
    @Resource
    private TTableNumRepo tableNumRepo;

    public Integer obtainMaxNum(String tableName, String fieldName){

        return tableNumService.obtainMaxNum(tableName, fieldName);
    }

    /**
     * 修改保存 表、字段的当前最大值
     * @param tableName
     * @param fieldName
     * @param maxNum
     * @return
     */
    @Transactional
    public BaseResponse saveMaxNum(String tableName, String fieldName, Integer maxNum){
        return tableNumService.saveMaxNum(tableName, fieldName, maxNum);
    }

    /**
     * 替换 匹配的fieldName
     * @param tableName
     * @param oldFieldName
     * @param newFieldName
     */
    @Transactional
    public Integer replaceFieldName(String tableName, String oldFieldName, String newFieldName){
        return tableNumRepo.replaceFieldName(tableName, oldFieldName, newFieldName);
    }
}
