package com.testor.module.accident.model.vo;

import com.testor.module.accident.model.domain.AccidentReport;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * @author zhangyangfan@testor.com.cn
 * @version 1.0
 * @description:
 * @date 2022/5/11 13:52
 */

@Data
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "AccidentReportVO表单", description = "")
public class AccidentReportVO extends AccidentReport {

    @ApiModelProperty(value = "上报人员手机号")
    private String reporterPhone;

    @ApiModelProperty(value = "假日类型名称")
    private String fakeTypeName;

    @ApiModelProperty(value = "上报人员名称")
    private String reporterName;

    @ApiModelProperty(value = "受伤人员")
    private List<AccidentPersonnelVO> accidentPersonnelList;
}
