package com.testor.module.contractor.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

@Getter
@AllArgsConstructor
public enum ProcessStatusEnum {

    /**
     * 待提交
     */
    WAITING_AUDIT("1", "待提交"),
    /**
     * 审核中
     */
    UNDER_REVIEW("2", "审核中"),
    /**
     * 审核不通过
     */
    AUDIT_PASS("3", "通过"),
    /**
     * 驳回
     */
    DISMISSED("4", "驳回");

    private final String value; // 状态值
    private final String description; // 状态描述

    /**
     * 根据状态值获取枚举
     *
     * @param value 状态值
     * @return 对应的枚举，如果没有找到则返回 null
     */
    public static ProcessStatusEnum fromValue(String value) {
        for (ProcessStatusEnum status : values()) {
            if (status.value.equals(value)) {
                return status;
            }
        }
        return null;
    }

    @Override
    public String toString() {
        return this.value + " - " + this.description;
    }

}
