package com.testor.module.contractor.manage.model.domain;

import java.time.LocalDateTime;

import com.testor.common.annotation.Translation;
import com.testor.common.annotation.TranslationType;
import com.testor.common.constant.TransConstant;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;


/**
 * 准入管理对象 t_contractor_allow
 * 
 * @author testor-framework
 * @date 2024-11-26 14:07:35
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_contractor_allow")
@ApiModel(value = "TContractorAllow对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TContractorAllow extends SuperModel
{
    private static final long serialVersionUID = 1L;
/**
 * id
 */
  @ApiModelProperty(value = "id")

  @TableId("id")
  private String id;
/**
 * 承包商台账id
 */
  @ApiModelProperty(value = "承包商台账id")

  @TableField("contractor_id")
  private String contractorId;
/**
 * 项目id
 */
  @ApiModelProperty(value = "项目id")

  @TableField("proj_id")
  private String projId;
/**
 * 流程实例ID
 */
  @ApiModelProperty(value = "流程实例ID")

  @TableField("process_id")
  private String processId;
/**
 * 流程状态
 */
  @ApiModelProperty(value = "流程状态")

  @TableField("process_status")
  @Translation(type = TransConstant.DICT_TYPE_TO_LABEL,other = "contractor_process_status")
  private String processStatus;
/**
 * 业务id(标识是一条基本信息产生的关系)
 */
  @ApiModelProperty(value = "业务id(标识是一条基本信息产生的关系)")

  @TableField("biz_id")
  private String bizId;

  /**
   * 机构id
   */
  @ApiModelProperty(value = "机构id")

  @TableField("org_id")
  private String orgId;

/**
 * 施工描述
 */
  @ApiModelProperty(value = "施工描述")

  @TableField("work_description")
  private String workDescription;
/**
 * 施工地点
 */
  @ApiModelProperty(value = "施工地点")

  @TableField("work_location")
  private String workLocation;
/**
 * 施工方案 附件
 */
  @ApiModelProperty(value = "施工方案 附件")

  @TableField("work_plan")
  private String workPlan;
/**
 * 应急预案 附件
 */
  @ApiModelProperty(value = "应急预案 附件")

  @TableField("emergency_plan")
  private String emergencyPlan;
/**
 * 健康安全告知书 附件
 */
  @ApiModelProperty(value = "健康安全告知书 附件")

  @TableField("health_safety_notice")
  private String healthSafetyNotice;
/**
 * 施工人员安全承诺 附件
 */
  @ApiModelProperty(value = "施工人员安全承诺 附件")

  @TableField("safety_commitment")
  private String safetyCommitment;

  public static final String ID ="id";
  public static final String CONTRACTOR_ID ="contractor_id";
  public static final String PROJ_ID ="proj_id";
  public static final String PROCESS_ID ="process_id";
  public static final String PROCESS_STATUS ="process_status";
  public static final String BIZ_ID ="biz_id";
  public static final String WORK_DESCRIPTION ="work_description";
  public static final String WORK_LOCATION ="work_location";
  public static final String WORK_PLAN ="work_plan";
  public static final String EMERGENCY_PLAN ="emergency_plan";
  public static final String HEALTH_SAFETY_NOTICE ="health_safety_notice";
  public static final String SAFETY_COMMITMENT ="safety_commitment";


}
