package com.testor.module.train.myManagement.service;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.testor.module.train.exam.model.domain.TTrainTestQuestions;
import com.testor.module.train.exam.service.TTrainTestQuestionsService;
import com.testor.module.train.myManagement.controller.TTrainMyManagementController;
import com.testor.module.train.myManagement.model.domain.TTrainTestQuestionsExercise;
import com.testor.module.train.myManagement.model.dto.TTrainTestQuestionsExerciseParam;
import com.testor.module.train.paper.model.dto.TestQuestionsContent;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import org.junit.jupiter.api.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

import java.util.ArrayList;
import java.util.List;

import static org.junit.jupiter.api.Assertions.*;
@RunWith(SpringRunner.class)
@SpringBootTest(webEnvironment = SpringBootTest.WebEnvironment.RANDOM_PORT, classes = StartupApplication.class)
class TTrainTestQuestionsExerciseServiceTest {

    @Autowired private TTrainTestQuestionsExerciseService tTrainTestQuestionsExerciseService;
    @Autowired
    private TTrainTestQuestionsService tTrainTestQuestionsService;

    @Autowired
    private TTrainMyManagementController tTrainMyManagementController;

    @Test
    void errorRecord() {
        BaseResponse<BaseResponseList<TestQuestionsContent>> baseResponse = new BaseResponse<>();
        BaseResponseList<TestQuestionsContent> baseResponseList = new BaseResponseList<>();


        TTrainTestQuestionsExerciseParam param = new TTrainTestQuestionsExerciseParam();
        String userId = "770ba30032664e7e8c683c026daa30f2";
        IPage<TTrainTestQuestionsExercise> affiliation = tTrainTestQuestionsExerciseService
                .errorRecord(param, userId);
        System.out.println(JSON.toJSONString(affiliation));
        // 获取所有试题id
        List<String> list = new ArrayList<>();
        for (TTrainTestQuestionsExercise record : affiliation.getRecords()) {
            list.add(record.getTestQuestionsId());
        }
        // 获取所有试题
        if (list.size() > 0) {
            List<TTrainTestQuestions> testQuestions = tTrainTestQuestionsService.list(new QueryWrapper<TTrainTestQuestions>()
                    .in(TTrainTestQuestions.ID, list)
            );
            // 获取试题及选项
            List<TestQuestionsContent> testList = tTrainMyManagementController.getTestQuestions(testQuestions);
            baseResponseList.setData(testList);
            baseResponseList.setTotal(affiliation.getTotal());
            baseResponse.setData(baseResponseList);
        }
        System.out.println(JSON.toJSONString(baseResponse));
    }
}