/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tfw.ureport.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.models.exceptions.ApiException;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;
import com.tongtech.tfw.ureport.UreportEnumCode;
import com.tongtech.tfw.ureport.model.domain.TUreportFile;
import com.tongtech.tfw.ureport.model.dto.TUreportFileDelParam;
import com.tongtech.tfw.ureport.model.dto.TUreportFileParam;
import com.tongtech.tfw.ureport.service.TUreportFileService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ureport-api/file"})
@Api(value="TUreportFile", tags={"Ureport File"})
public class TUreportFileController
extends SuperController {
    private static final Logger log = LoggerFactory.getLogger(TUreportFileController.class);
    @Autowired
    private TUreportFileService tUreportFileService;

    @ApiOperation(value="\u65b0\u589e Ureport File", notes="Add TUreportFile")
    @PostMapping(value={"/add"})
    public BaseResponse<TUreportFile> addEntity(@RequestBody TUreportFile addRequest) {
        BaseResponse baseResponse = new BaseResponse();
        if (Objects.nonNull((Object)addRequest)) {
            if (Objects.isNull(addRequest.getName()) || StringUtils.isBlank((CharSequence)addRequest.getName())) {
                throw new ApiException(UreportEnumCode.TEMPLATE_NAME_EMPTY.transform());
            }
            TUreportFile tUreportFile = this.tUreportFileService.queryUreportFileByName(addRequest.getName());
            if (null != tUreportFile && StringUtils.isNotEmpty((CharSequence)tUreportFile.getId())) {
                throw new ApiException(UreportEnumCode.TEMPLATE_NAME_EXISTED.transform());
            }
            String id = IdHelper.getId32bit();
            TUreportFile data = (TUreportFile)((Object)BeanHelper.beanToBean((Object)((Object)addRequest), TUreportFile.class));
            if (StringUtils.isNotEmpty((CharSequence)addRequest.getTemplateId())) {
                TUreportFile template = (TUreportFile)((Object)this.tUreportFileService.getById((Serializable)((Object)addRequest.getTemplateId())));
                if (null != template && StringUtils.isNotEmpty((CharSequence)template.getContent())) {
                    data.setContent(template.getContent());
                } else {
                    data.setContent(this.getDefaultUreport());
                }
            } else {
                data.setContent(this.getDefaultUreport());
            }
            data.setId(id);
            data.setCreateBy(this.getUserId());
            data.setUpdateBy(this.getUserId());
            data.setCreateDate(LocalDateTime.now());
            data.setUpdateDate(LocalDateTime.now());
            data.setStatus("0");
            data.setIsPublish("0");
            boolean result = this.tUreportFileService.save((Object)data);
            if (result) {
                TUreportFile newEntity = new TUreportFile();
                newEntity.setId(id);
                baseResponse.setData((Object)newEntity);
            }
        }
        return baseResponse;
    }

    @ApiOperation(value="\u83b7\u53d6 Ureport File ", notes="Get TUreportFile By Id")
    @GetMapping(value={"/get"})
    public BaseResponse<TUreportFile> getById(String id) {
        BaseResponse baseResponse = new BaseResponse();
        if (StringUtils.isNotEmpty((CharSequence)id)) {
            TUreportFile data = (TUreportFile)((Object)this.tUreportFileService.getById((Serializable)((Object)id)));
            baseResponse.setData((Object)data);
        }
        return baseResponse;
    }

    @ApiOperation(value="\u4fee\u6539 Ureport File ", notes="Update TUreportFile By Id")
    @PutMapping(value={"/update"})
    public BaseResponse<BizGeneralResponse> updateEntity(@RequestBody TUreportFile updateRequest) {
        BaseResponse baseResponse = new BaseResponse();
        if (Objects.nonNull((Object)updateRequest) && StringUtils.isNotEmpty((CharSequence)updateRequest.getId())) {
            TUreportFile data = (TUreportFile)((Object)BeanHelper.beanToBean((Object)((Object)updateRequest), TUreportFile.class));
            data.setUpdateBy(this.getUserId());
            data.setUpdateDate(LocalDateTime.now());
            boolean result = this.tUreportFileService.updateById((Object)data);
            baseResponse.setData((Object)BizGeneralResponse.builder().result(TypeHelper.castToString((Object)result)).build());
        }
        return baseResponse;
    }

    @ApiOperation(value="\u5220\u9664 Ureport File ", notes="delete TUreportFile By Id")
    @PutMapping(value={"/delete"})
    public BaseResponse<BizGeneralResponse> deleteEntity(@RequestBody TUreportFileDelParam deleteRequest) {
        BaseResponse baseResponse = new BaseResponse();
        if (Objects.nonNull(deleteRequest) && StringUtils.isNotEmpty((CharSequence)deleteRequest.getId())) {
            TUreportFile data = new TUreportFile();
            data.setId(deleteRequest.getId());
            data.setStatus("1");
            data.setUpdateBy(this.getUserId());
            data.setUpdateDate(LocalDateTime.now());
            boolean result = this.tUreportFileService.updateById((Object)data);
            baseResponse.setData((Object)BizGeneralResponse.builder().result(TypeHelper.castToString((Object)result)).build());
        }
        return baseResponse;
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664Ureport File", notes="delete TUreportFile by batch Id")
    @PutMapping(value={"/batch_delete"})
    public BaseResponse<BizGeneralResponse> deleteEntityBatch(@RequestBody TUreportFileDelParam deleteRequest) {
        BaseResponse baseResponse = new BaseResponse();
        if (Objects.nonNull(deleteRequest) && !deleteRequest.getIds().isEmpty()) {
            ArrayList<TUreportFile> tUreportFileList = new ArrayList<TUreportFile>();
            for (String id : deleteRequest.getIds()) {
                TUreportFile data = new TUreportFile();
                data.setId(id);
                data.setStatus("1");
                data.setUpdateBy(this.getUserId());
                data.setUpdateDate(LocalDateTime.now());
                tUreportFileList.add(data);
            }
            boolean result = this.tUreportFileService.updateBatchById(tUreportFileList);
            baseResponse.setData((Object)BizGeneralResponse.builder().result(TypeHelper.castToString((Object)result)).build());
        }
        return baseResponse;
    }

    @ApiOperation(value="\u83b7\u53d6 Ureport File \u5206\u9875\u5217\u8868", notes="List TUreportFile with page")
    @GetMapping(value={"/list"})
    public BaseResponse<BaseResponseList<TUreportFile>> listEntity(TUreportFileParam param) {
        BaseResponse baseResponse = new BaseResponse();
        Long page = StringUtils.isEmpty((CharSequence)param.getPage()) ? BizConstants.PAGE : Long.valueOf(param.getPage());
        Long limit = StringUtils.isEmpty((CharSequence)param.getLimit()) ? BizConstants.LIMIT : Long.valueOf(param.getLimit());
        Page resultPage = new Page(page.longValue(), limit.longValue());
        QueryWrapper<TUreportFile> queryWrapper = this.createQuery(param);
        Page resultList = (Page)this.tUreportFileService.page((IPage)resultPage, (Wrapper)queryWrapper);
        BaseResponseList baseResponseList = new BaseResponseList();
        baseResponseList.setData(resultList.getRecords());
        baseResponseList.setTotal(resultList.getTotal());
        baseResponse.setData((Object)baseResponseList);
        return baseResponse;
    }

    @ApiOperation(value="\u83b7\u53d6 Ureport File \u5217\u8868", notes="List TUreportFile all")
    @GetMapping(value={"/datas"})
    public BaseResponse<BaseResponseList<TUreportFile>> listAllEntity(TUreportFileParam param) {
        BaseResponse baseResponse = new BaseResponse();
        QueryWrapper<TUreportFile> queryWrapper = this.createQuery(param);
        List resultList = this.tUreportFileService.list((Wrapper)queryWrapper);
        BaseResponseList baseResponseList = new BaseResponseList();
        baseResponseList.setData(resultList);
        baseResponseList.setTotal((long)resultList.size());
        baseResponse.setData((Object)baseResponseList);
        return baseResponse;
    }

    private QueryWrapper<TUreportFile> createQuery(TUreportFileParam queryParam) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((CharSequence)queryParam.getStatus())) {
            queryWrapper.eq((Object)"status", (Object)queryParam.getStatus());
        }
        if (StringUtils.isNotEmpty((CharSequence)queryParam.getCreateByOrg())) {
            queryWrapper.eq((Object)"create_by_org", (Object)queryParam.getCreateByOrg());
        }
        if (StringUtils.isNotEmpty((CharSequence)queryParam.getName())) {
            queryWrapper.like((Object)"name", (Object)queryParam.getName());
        }
        if (StringUtils.isNotEmpty((CharSequence)queryParam.getContent())) {
            queryWrapper.eq((Object)"content", (Object)queryParam.getContent());
        }
        if (Objects.nonNull(queryParam.getViewCount())) {
            queryWrapper.eq((Object)"view_count", (Object)queryParam.getViewCount());
        }
        if (StringUtils.isNotEmpty((CharSequence)queryParam.getTemplateId())) {
            queryWrapper.eq((Object)"template_id", (Object)queryParam.getTemplateId());
        }
        if (Objects.nonNull(queryParam.getIsTemplate())) {
            queryWrapper.eq((Object)"is_template", (Object)queryParam.getIsTemplate());
        }
        if (Objects.nonNull(queryParam.getTypeId())) {
            queryWrapper.eq((Object)"type_id", (Object)queryParam.getTypeId());
        }
        if (StringUtils.isNotEmpty((CharSequence)queryParam.getDeptId())) {
            queryWrapper.eq((Object)"dept_id", (Object)queryParam.getDeptId());
        }
        if (StringUtils.isNotEmpty((CharSequence)queryParam.getIsPublish())) {
            queryWrapper.eq((Object)"is_publish", (Object)queryParam.getIsPublish());
        }
        if (StringUtils.isNotEmpty((CharSequence)queryParam.getStatus())) {
            queryWrapper.eq((Object)"status", (Object)queryParam.getStatus());
        } else {
            queryWrapper.ne((Object)"status", (Object)"1");
        }
        if (StringUtils.isNotEmpty((CharSequence)queryParam.getOrderBy())) {
            if (StringUtils.isNotEmpty((CharSequence)queryParam.getOrderType()) && "asc".equals(queryParam.getOrderType())) {
                queryWrapper.orderByAsc((Object)queryParam.getOrderBy());
            } else {
                queryWrapper.orderByDesc((Object)queryParam.getOrderBy());
            }
        } else {
            queryWrapper.orderByDesc((Object)"update_date");
        }
        return queryWrapper;
    }

    private String getDefaultUreport() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?><ureport><cell expand=\"None\" name=\"A1\" row=\"1\" col=\"1\"><cell-style font-size=\"10\" align=\"center\" valign=\"middle\"></cell-style><simple-value><![CDATA[]]></simple-value></cell><cell expand=\"None\" name=\"B1\" row=\"1\" col=\"2\"><cell-style font-size=\"10\" align=\"center\" valign=\"middle\"></cell-style><simple-value><![CDATA[]]></simple-value></cell><cell expand=\"None\" name=\"C1\" row=\"1\" col=\"3\"><cell-style font-size=\"10\" align=\"center\" valign=\"middle\"></cell-style><simple-value><![CDATA[]]></simple-value></cell><cell expand=\"None\" name=\"D1\" row=\"1\" col=\"4\"><cell-style font-size=\"10\" align=\"center\" valign=\"middle\"></cell-style><simple-value><![CDATA[]]></simple-value></cell><cell expand=\"None\" name=\"A2\" row=\"2\" col=\"1\"><cell-style font-size=\"10\" align=\"center\" valign=\"middle\"></cell-style><simple-value><![CDATA[]]></simple-value></cell><cell expand=\"None\" name=\"B2\" row=\"2\" col=\"2\"><cell-style font-size=\"10\" align=\"center\" valign=\"middle\"></cell-style><simple-value><![CDATA[]]></simple-value></cell><cell expand=\"None\" name=\"C2\" row=\"2\" col=\"3\"><cell-style font-size=\"10\" align=\"center\" valign=\"middle\"></cell-style><simple-value><![CDATA[]]></simple-value></cell><cell expand=\"None\" name=\"D2\" row=\"2\" col=\"4\"><cell-style font-size=\"10\" align=\"center\" valign=\"middle\"></cell-style><simple-value><![CDATA[]]></simple-value></cell><cell expand=\"None\" name=\"A3\" row=\"3\" col=\"1\"><cell-style font-size=\"10\" align=\"center\" valign=\"middle\"></cell-style><simple-value><![CDATA[]]></simple-value></cell><cell expand=\"None\" name=\"B3\" row=\"3\" col=\"2\"><cell-style font-size=\"10\" align=\"center\" valign=\"middle\"></cell-style><simple-value><![CDATA[]]></simple-value></cell><cell expand=\"None\" name=\"C3\" row=\"3\" col=\"3\"><cell-style font-size=\"10\" align=\"center\" valign=\"middle\"></cell-style><simple-value><![CDATA[]]></simple-value></cell><cell expand=\"None\" name=\"D3\" row=\"3\" col=\"4\"><cell-style font-size=\"10\" align=\"center\" valign=\"middle\"></cell-style><simple-value><![CDATA[]]></simple-value></cell><row row-number=\"1\" height=\"18\"/><row row-number=\"2\" height=\"18\"/><row row-number=\"3\" height=\"18\"/><column col-number=\"1\" width=\"80\"/><column col-number=\"2\" width=\"80\"/><column col-number=\"3\" width=\"80\"/><column col-number=\"4\" width=\"80\"/><datasource name=\"DataSource\" type=\"buildin\"></datasource><paper type=\"A4\" left-margin=\"90\" right-margin=\"90\"\n    top-margin=\"72\" bottom-margin=\"72\" paging-mode=\"fitpage\" fixrows=\"0\"\n    width=\"595\" height=\"842\" orientation=\"portrait\" html-report-align=\"left\" bg-image=\"\" html-interval-refresh-value=\"0\" column-enabled=\"false\"></paper></ureport>";
    }
}

