package com.testor.common.excel.select.impl;


import com.testor.biz.sys.dict.data.model.domain.SysDictData;
import com.testor.common.annotation.ExcelSelectedType;
import com.testor.common.constant.ExcelSelectConstant;
import com.testor.common.excel.select.ExcelDynamicSelect;
import com.testor.module.sys.service.NewSysDictDataService;
import lombok.AllArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.stream.Collectors;


@Component
@AllArgsConstructor
@ExcelSelectedType(type = ExcelSelectConstant.DICT_DATA_BY_TYPE)
public class DictDataSelectImpl implements ExcelDynamicSelect<String> {

    @Autowired
    private NewSysDictDataService newSysDictDataService;

    @Override
    public List<String> getSource(Object param) {
        List<SysDictData> dictByType = newSysDictDataService.getDictByType(param.toString());
        if (dictByType != null) {
            return dictByType.stream().map(SysDictData::getDictValue).collect(Collectors.toList());
        }
        return null;
    }
}
