package com.testor.ddd.safetyControl.domain.equipment.service.impl;

import cn.hutool.core.util.StrUtil;
import com.testor.ddd.safetyControl.domain.equipment.entity.TSafeEquipmentTypeRepo;
import com.testor.ddd.safetyControl.domain.equipment.service.EquipmentTypeService;
import com.testor.ddd.safetyControl.interfaces.model.dto.equipment.TSafeEquipmentTypeDTO;
import com.testor.ddd.safetyControl.interfaces.model.dto.equipment.TSafeEquipmentTypeDTOParam;
import com.testor.ddd.safetyControl.interfaces.model.vo.equipment.TSafeEquipmentTypeVO;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.constants.enumeration.BaseStatusEnum;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

@Service
public class EquipmentTypeServiceImpl implements EquipmentTypeService {

    @Resource
    private TSafeEquipmentTypeRepo equipmentTypeRepo;

    /**
     * 检测 名称、编码 是否都唯一
     * @param id
     * @param name
     * @param code
     * @return true - 唯一； false - 不唯一
     */
    public boolean checkUniqueness(String id, String name, String code){
        List<TSafeEquipmentTypeDTO> equipmentTypeDTOList = equipmentTypeRepo.checkUniqueness(id, name, code);
        if(equipmentTypeDTOList == null || equipmentTypeDTOList.size() == 0) {
            return true;
        }
        return false;
    }

    /**
     * 编辑空间
     *
     * @param equipmentTypeDto
     * @return
     */
    @Transactional
    public BaseResponse editEquipmentType(String userId, String orgId, TSafeEquipmentTypeDTO equipmentTypeDto) {
        BaseResponse baseResponse = new BaseResponse<>();

        boolean checkResult = checkUniqueness(equipmentTypeDto.getId(), equipmentTypeDto.getName(), equipmentTypeDto.getCode());
        if (!checkResult) {
            baseResponse.setCode(BaseStatusEnum.UNKNOWN.code());
            baseResponse.setMsg("已存在相同名称/编码的数据");
            return baseResponse;
        }

        String dataId = equipmentTypeDto.getId();
        if (StrUtil.isBlank(dataId)) { // 新增
            equipmentTypeDto.setCreateBy(userId);
            equipmentTypeDto.setOrgId(orgId);
            equipmentTypeRepo.insert(equipmentTypeDto);
            return baseResponse;
        }

        if (!orgId.equals(equipmentTypeDto.getOrgId())) {
            baseResponse.setCode(BaseStatusEnum.UN_DATA.code());
            baseResponse.setMsg("当前用户无法操作该条数据");
            return baseResponse;
        }

        equipmentTypeDto.setUpdateBy(userId);
        equipmentTypeRepo.updateById(equipmentTypeDto);
        return baseResponse;
    }

    public BaseResponseList<TSafeEquipmentTypeVO> listByPage(TSafeEquipmentTypeDTOParam param){

        BaseResponseList<TSafeEquipmentTypeVO> baseResponseList=new BaseResponseList<>();
        baseResponseList = equipmentTypeRepo.listPage(param);
        return baseResponseList;
    }

    public TSafeEquipmentTypeDTO findById(String id){
        return equipmentTypeRepo.findById(id);
    }
}
