package com.testor.ddd.safetyControl.infrastructure.repository.lecls.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;


/**
 * lec ls与风险等级关系对象 t_safe_risk_lecls_relation
 * 
 * @author testor-framework
 * @date 2022-07-27 14:12:00
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_safe_risk_lecls_relation")
@ApiModel(value = "TSafeRiskLeclsRelation对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TSafeRiskLeclsRelationDO extends SuperModel
{
    private static final long serialVersionUID = 1L;
/**
 * id
 */
  @ApiModelProperty(value = "id")
  @TableId(value = "id",type = IdType.ASSIGN_UUID)
  private String id;
/**
 * 1-lec;2-ls

 */
  @ApiModelProperty(value = "1-lec;2-ls " , example = "0")
  @TableField("type")
  private Integer type;
/**
 * 1-采用范围值，2-采用具体值

 */
  @ApiModelProperty(value = "1-采用范围值，2-采用具体值 " , example = "0")
  @TableField("value_type")
  private Integer valueType;
/**
 * 最大值
 */
  @ApiModelProperty(value = "最大值" , example = "0")

  @TableField("max_value")
  private Float maxValue;
/**
 * 最小值
 */
  @ApiModelProperty(value = "最小值" , example = "0")

  @TableField("min_value")
  private Float minValue;

  /**
   * 现实风险
   */
  @ApiModelProperty(value = "表达式")
  @TableField("formula_str")
  private String formulaStr;

  /**
 * 具体值
 */
  @ApiModelProperty(value = "具体值" , example = "0")

  @TableField("value")
  private Float value;
/**
 * 现实风险
 */
  @ApiModelProperty(value = "现实风险")

  @TableField("real_level")
  private String realLevel;
/**
 * 是否包含最大值（0-不包含，1-包含）
 */
  @ApiModelProperty(value = "是否包含最大值（0-不包含，1-包含）")

  @TableField("is_include_max")
  private String isIncludeMax;
/**
 * 是否包含最小值（0-不包含，1-包含）
 */
  @ApiModelProperty(value = "是否包含最小值（0-不包含，1-包含）")

  @TableField("is_include_min")
  private String isIncludeMin;

  public static final String ID ="id";
  public static final String TYPE ="type";
  public static final String VALUE_TYPE ="value_type";
  public static final String MAX_VALUE ="max_value";
  public static final String MIN_VALUE ="min_value";
  public static final String VALUE ="value";
  public static final String REAL_LEVEL ="real_level";
  public static final String IS_INCLUDE_MAX ="is_include_max";
  public static final String IS_INCLUDE_MIN ="is_include_min";
  public static final String FORMULA_STR ="formula_str";

}
