package com.testor.module.accident.model.excel;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.jeecgframework.poi.excel.annotation.ExcelCollection;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @title AccidentInportVO
 * @description <TODO description class purpose>
 * @Author: qiao
 * @version:1.0.0
 * @create：5/25/23 3:26 PM
 */

@Data
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
public class AccidentInportVO implements Serializable {
    @ApiModelProperty("序号")
    @Excel(name = "序号", width = 20)
    private int serialNumber;

    @ApiModelProperty("业务单位名称")
    @Excel(name = "业务单位名称", width = 20)
    private String regionalCompanyName;

    @ApiModelProperty("基层企业名称")
    @Excel(name = "基层企业名称", width = 20)
    private String basicUnitName;

    @ApiModelProperty("上报时间-年")
    @Excel(name = "上报时间-年", width = 20)
    private int reportTimeYear;

    @ApiModelProperty("上报时间-月")
    @Excel(name = "上报时间-月", width = 20)
    private int reportTimeMonth;

    @ApiModelProperty("上报时间-日")
    @Excel(name = "上报时间-日", width = 20)
    private int reportTimeDay;

    @ApiModelProperty("上报时间-时")
    @Excel(name = "上报时间-时", width = 20)
    private int reportTimeHour;

    @ApiModelProperty(value = "小事故等级（轻事故/微事故/险兆事件）")
    @Excel(name = "小事故等级（轻事故/微事故/险兆事件", width = 20)
    private String accidentLevelName;

    @ApiModelProperty(value = "事故类型")
    @Excel(name = "事故类型", width = 20)
    private String accidentTypeName;

    @ApiModelProperty(value = "经济损失——合计（万元）")
    @Excel(name = "经济损失——合计（万元）", width = 20)
    private BigDecimal totalEconomicLoss;

    @ApiModelProperty(value = "经济损失——直接(万元）")
    @Excel(name = "经济损失——直接(万元）", width = 20)
    private BigDecimal directEconomicLoss;

    @ApiModelProperty(value = "经济损失——间接（万元）")
    @Excel(name = "经济损失——间接（万元）", width = 20)
    private BigDecimal indirectEconomicLoss;

    @ApiModelProperty(value = "事故经过简述")
    @Excel(name = "事故经过简述", width = 20)
    private String accidentPassed;

    @ApiModelProperty(value = "事故原因（填写字母代号，多种原因以“/”分隔）")
    @Excel(name = "事故原因（填写字母代号，多种原因以“/”分隔）", width = 20)
    private String accidentCause;

    @ApiModelProperty(value = "改善措施（及最佳实践★）")
    @Excel(name = "改善措施（及最佳实践★）", width = 20)
    private String improvements;

    @ApiModelProperty(value = "备注")
    @Excel(name = "备注", width = 20)
    private String remarks;

    @ApiModelProperty("是否节假日")
    @Excel(name = "是否节假日", width = 20)
    private String fakeTypeName;


    @ExcelCollection(name = "受伤人员信息")
    private List<AccidentPersonnelVO> list;
}
