package com.testor.module.iam.model.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;
import java.util.Date;

/**
 * @ClassName: IamMessage
 * @Description: TODO
 * @Author: lm
 * @CreateTime: 2024/1/2 14:07
 * @Version: 1.0
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode()
@TableName("iam_message")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class IamMessage {

    /**
     * id
     */
    @TableId
    private String id;

    /**
     * 数据类型
     * user|department
     */
    private String dataType;

    /**
     * 操作类型CREATE|UPDATE|DELETE
     */
    private String operateType;

    /**
     * 变动的数据id，可以通过此id进行查询
     */
    private String dataId;

    /**
     * 流水号
     */
    private String sn;

    /**
     * 消息状态，
     * 新消息：0；处理失败：1；成功：2；忽略：3
     */
    private String status;

    @ApiModelProperty("创建者")
    private String createBy;
    @ApiModelProperty("创建时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createDate;
    @ApiModelProperty("最后一次更新者")
    private String updateBy;
    @ApiModelProperty("最后一次更新时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateDate;
    @ApiModelProperty("备注")
    @TableField("remarks")
    private String remarks;

}
