package com.testor.module.train.project.model.stat;

import com.alibaba.excel.annotation.ExcelProperty;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author caq
 * @date 2024/9/7
 * @description 个人档案列表结果
 */
@Data
public class TrainProjectUserListVo {

    private String userId;
    private String loginName;
    @ExcelProperty(value = "人员姓名", index = 0)
    private String userName;
    @ApiModelProperty(value = "部门id")
    private String deptId;
    @ExcelProperty(value = "所属部门", index = 1)
    private String deptName;

    @ApiModelProperty(value = "人员类型")
    private String userTypeCode;
    @ExcelProperty(value = "人员类型", index = 2)
    private String userTypeName;

    @ApiModelProperty(value = "企业选择 1 本单位 2 相关方")
    private String personAffiliation;

    @ApiModelProperty(value = "专业化指数评分")
    @ExcelProperty(value = "专业化指数评分", index = 3)
    private String totalScore;
    @ApiModelProperty(value = "培训次数")
    @ExcelProperty(value = "培训次数", index = 4)
    private String trainNum;
    @ApiModelProperty(value = "考试次数")
    @ExcelProperty(value = "考试次数", index = 5)
    private String testNum;
    @ApiModelProperty(value = "评价次数")
    @ExcelProperty(value = "评价次数", index = 6)
    private String gradeNum;



}
