/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.commons.license.bean.cfg;

import com.tongweb.commons.license.bean.cfg.LicenseConfig;
import com.tongweb.commons.utils.StringUtils;

public class LicenseFileConfig
extends LicenseConfig {
    private String filePath;
    private String mode;

    private LicenseFileConfig(Builder builder) {
        this.setTongwebEdition(builder.tongWebEdition);
        if (StringUtils.isNotEmpty(builder.tongWebName)) {
            this.setTongWebName(builder.tongWebName);
        }
        this.setProductVersion(builder.productVersion);
        this.setFilePath(builder.filePath);
        this.setMode(builder.mode);
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    @Override
    public String toString() {
        return "LicenseFileConfig{filePath='" + this.filePath + '\'' + ", mode='" + this.mode + '\'' + "} " + super.toString();
    }

    public static final class Builder {
        private String productVersion;
        private String tongWebEdition;
        private String tongWebName;
        private String filePath;
        private String mode;

        public Builder productVersion(String val) {
            this.productVersion = val;
            return this;
        }

        public Builder filePath(String val) {
            this.filePath = val;
            return this;
        }

        public Builder mode(String val) {
            this.mode = val;
            return this;
        }

        public LicenseFileConfig build() {
            return new LicenseFileConfig(this);
        }

        public Builder tongwebEdition(String val) {
            this.tongWebEdition = val;
            return this;
        }

        public Builder tongWebName(String val) {
            this.tongWebName = val;
            return this;
        }
    }
}

