/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tfw.backend.common.models.response;

import com.tongtech.tfw.backend.common.models.response.ResponseInfo;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import java.time.LocalDateTime;
import javax.servlet.http.HttpServletRequest;

public class SuccessResponse {
    private final Integer code;
    private final String msg;
    private final Object result;
    private final String info;
    private final LocalDateTime time;

    public static SuccessResponse buildSuccessResponse(HttpServletRequest request, ResponseInfo successResponseInfo, Object result) {
        SuccessResponseBuilder builder = SuccessResponse.builder();
        if (ObjectHelper.isNotEmpty((Object)successResponseInfo)) {
            builder.code(successResponseInfo.getCode()).msg(successResponseInfo.getMsg());
        }
        if (ObjectHelper.isNotEmpty((Object)result)) {
            builder.result(result);
        }
        if (ObjectHelper.isNotEmpty((Object)request)) {
            builder.info((String)request.getAttribute("requestId"));
        }
        builder.time(LocalDateTime.now());
        return builder.build();
    }

    SuccessResponse(Integer code, String msg, Object result, String info, LocalDateTime time) {
        this.code = code;
        this.msg = msg;
        this.result = result;
        this.info = info;
        this.time = time;
    }

    public static SuccessResponseBuilder builder() {
        return new SuccessResponseBuilder();
    }

    public Integer getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public Object getResult() {
        return this.result;
    }

    public String getInfo() {
        return this.info;
    }

    public LocalDateTime getTime() {
        return this.time;
    }

    public String toString() {
        return "SuccessResponse(code=" + this.getCode() + ", msg=" + this.getMsg() + ", result=" + this.getResult() + ", info=" + this.getInfo() + ", time=" + this.getTime() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SuccessResponse)) {
            return false;
        }
        SuccessResponse other = (SuccessResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$code = this.getCode();
        Integer other$code = other.getCode();
        if (this$code == null ? other$code != null : !((Object)this$code).equals(other$code)) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
            return false;
        }
        Object this$result = this.getResult();
        Object other$result = other.getResult();
        if (this$result == null ? other$result != null : !this$result.equals(other$result)) {
            return false;
        }
        String this$info = this.getInfo();
        String other$info = other.getInfo();
        if (this$info == null ? other$info != null : !this$info.equals(other$info)) {
            return false;
        }
        LocalDateTime this$time = this.getTime();
        LocalDateTime other$time = other.getTime();
        return !(this$time == null ? other$time != null : !((Object)this$time).equals(other$time));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SuccessResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : ((Object)$code).hashCode());
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        Object $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : $result.hashCode());
        String $info = this.getInfo();
        result = result * 59 + ($info == null ? 43 : $info.hashCode());
        LocalDateTime $time = this.getTime();
        result = result * 59 + ($time == null ? 43 : ((Object)$time).hashCode());
        return result;
    }

    public static class SuccessResponseBuilder {
        private Integer code;
        private String msg;
        private Object result;
        private String info;
        private LocalDateTime time;

        SuccessResponseBuilder() {
        }

        public SuccessResponseBuilder code(Integer code) {
            this.code = code;
            return this;
        }

        public SuccessResponseBuilder msg(String msg) {
            this.msg = msg;
            return this;
        }

        public SuccessResponseBuilder result(Object result) {
            this.result = result;
            return this;
        }

        public SuccessResponseBuilder info(String info) {
            this.info = info;
            return this;
        }

        public SuccessResponseBuilder time(LocalDateTime time) {
            this.time = time;
            return this;
        }

        public SuccessResponse build() {
            return new SuccessResponse(this.code, this.msg, this.result, this.info, this.time);
        }

        public String toString() {
            return "SuccessResponse.SuccessResponseBuilder(code=" + this.code + ", msg=" + this.msg + ", result=" + this.result + ", info=" + this.info + ", time=" + this.time + ")";
        }
    }
}

