/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.springboot.properties;

import com.tongweb.springboot.properties.Ssl;
import com.tongweb.springboot.properties.TongwebConfig;
import com.tongweb.springboot.starter.Shutdown;
import java.net.InetAddress;
import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.autoconfigure.web.ErrorProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.DeprecatedConfigurationProperty;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.boot.web.server.Http2;
import org.springframework.boot.web.servlet.server.Jsp;
import org.springframework.boot.web.servlet.server.Session;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Configuration
@ConfigurationProperties(prefix="server", ignoreUnknownFields=true)
public class TongWebProperties {
    private Integer port = 8088;
    private InetAddress address;
    @NestedConfigurationProperty
    private final ErrorProperties error = new ErrorProperties();
    private ForwardHeadersStrategy forwardHeadersStrategy = ForwardHeadersStrategy.NONE;
    private String serverHeader;
    private String maxHttpHeaderSize = "8KB";
    private String maxHttpPostSize = "2MB";
    private Duration connectionTimeout;
    @NestedConfigurationProperty
    private Ssl ssl;
    private final Compression compression = new Compression();
    @NestedConfigurationProperty
    private final Http2 http2 = new Http2();
    private final Servlet servlet = new Servlet();
    @NestedConfigurationProperty
    private final TongwebConfig tongweb = new TongwebConfig();
    private final Netty netty = new Netty();
    private Shutdown shutdown;
    private final Map<String, String> contextParameters = new HashMap<String, String>();
    private String contextPath;
    private String applicationDisplayName = "application";
    @NestedConfigurationProperty
    private final Jsp jsp = new Jsp();
    @NestedConfigurationProperty
    private final Session session = new Session();
    private int messageTimeout = 0;
    private int maxAttackTimes = 3;
    private int blacklistExpiredHours = 12;
    private boolean interruptCurrentConnect = true;

    public Shutdown getShutdown() {
        return this.shutdown;
    }

    public void setShutdown(Shutdown shutdown) {
        this.shutdown = shutdown;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public void setAddress(InetAddress address) {
        this.address = address;
    }

    @DeprecatedConfigurationProperty(reason="replaced to support additional strategies", replacement="server.forward-headers-strategy")
    public Boolean isUseForwardHeaders() {
        return ForwardHeadersStrategy.NATIVE.equals((Object)this.forwardHeadersStrategy);
    }

    public void setUseForwardHeaders(Boolean useForwardHeaders) {
        this.forwardHeadersStrategy = Boolean.TRUE.equals(useForwardHeaders) ? ForwardHeadersStrategy.NATIVE : ForwardHeadersStrategy.NONE;
    }

    public String getServerHeader() {
        return this.serverHeader;
    }

    public void setServerHeader(String serverHeader) {
        this.serverHeader = serverHeader;
    }

    public String getMaxHttpHeaderSize() {
        return this.maxHttpHeaderSize;
    }

    public void setMaxHttpHeaderSize(String maxHttpHeaderSize) {
        this.maxHttpHeaderSize = maxHttpHeaderSize;
    }

    public String getMaxHttpPostSize() {
        return this.maxHttpPostSize;
    }

    public void setMaxHttpPostSize(String maxHttpPostSize) {
        this.maxHttpPostSize = maxHttpPostSize;
    }

    @Deprecated
    @DeprecatedConfigurationProperty(reason="Each server behaves differently. Use server specific properties instead.")
    public Duration getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Deprecated
    public void setConnectionTimeout(Duration connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public ErrorProperties getError() {
        return this.error;
    }

    public Ssl getSsl() {
        return this.ssl;
    }

    public void setSsl(Ssl ssl) {
        this.ssl = ssl;
    }

    public Compression getCompression() {
        return this.compression;
    }

    public Http2 getHttp2() {
        return this.http2;
    }

    public Servlet getServlet() {
        return this.servlet;
    }

    public Netty getNetty() {
        return this.netty;
    }

    public TongwebConfig getTongweb() {
        return this.tongweb;
    }

    public ForwardHeadersStrategy getForwardHeadersStrategy() {
        return this.forwardHeadersStrategy;
    }

    public void setForwardHeadersStrategy(ForwardHeadersStrategy forwardHeadersStrategy) {
        this.forwardHeadersStrategy = forwardHeadersStrategy;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = this.cleanContextPath(contextPath);
    }

    private String cleanContextPath(String contextPath) {
        String candidate = StringUtils.trimWhitespace((String)contextPath);
        if (StringUtils.hasText((String)candidate) && candidate.endsWith("/")) {
            return candidate.substring(0, candidate.length() - 1);
        }
        return candidate;
    }

    public String getApplicationDisplayName() {
        return this.applicationDisplayName;
    }

    public void setApplicationDisplayName(String displayName) {
        this.applicationDisplayName = displayName;
    }

    public Map<String, String> getContextParameters() {
        return this.contextParameters;
    }

    public Jsp getJsp() {
        return this.jsp;
    }

    public Session getSession() {
        return this.session;
    }

    public int getMessageTimeout() {
        return this.messageTimeout;
    }

    public void setMessageTimeout(int messageTimeout) {
        this.messageTimeout = messageTimeout;
    }

    public int getMaxAttackTimes() {
        return this.maxAttackTimes;
    }

    public void setMaxAttackTimes(int maxAttackTimes) {
        this.maxAttackTimes = maxAttackTimes;
    }

    public int getBlacklistExpiredHours() {
        return this.blacklistExpiredHours;
    }

    public void setBlacklistExpiredHours(int blacklistExpiredHours) {
        this.blacklistExpiredHours = blacklistExpiredHours;
    }

    public boolean isInterruptCurrentConnect() {
        return this.interruptCurrentConnect;
    }

    public void setInterruptCurrentConnect(boolean interruptCurrentConnect) {
        this.interruptCurrentConnect = interruptCurrentConnect;
    }

    public static enum ForwardHeadersStrategy {
        NATIVE,
        FRAMEWORK,
        NONE;

    }

    public static class Netty {
        private Duration connectionTimeout;

        public Duration getConnectionTimeout() {
            return this.connectionTimeout;
        }

        public void setConnectionTimeout(Duration connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
        }
    }

    public static class Servlet {
        private final Map<String, String> contextParameters = new HashMap<String, String>();
        private String contextPath;
        private String applicationDisplayName = "application";
        private String path = "/";
        @NestedConfigurationProperty
        private final Jsp jsp = new Jsp();
        @NestedConfigurationProperty
        private final Session session = new Session();

        public String getContextPath() {
            return this.contextPath;
        }

        public void setContextPath(String contextPath) {
            this.contextPath = this.cleanContextPath(contextPath);
        }

        private String cleanContextPath(String contextPath) {
            if (StringUtils.hasText((String)contextPath) && contextPath.endsWith("/")) {
                return contextPath.substring(0, contextPath.length() - 1);
            }
            return contextPath;
        }

        public String getApplicationDisplayName() {
            return this.applicationDisplayName;
        }

        public void setApplicationDisplayName(String displayName) {
            this.applicationDisplayName = displayName;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            Assert.notNull((Object)path, (String)"Path must not be null");
            this.path = path;
        }

        public Map<String, String> getContextParameters() {
            return this.contextParameters;
        }

        public Jsp getJsp() {
            return this.jsp;
        }

        public Session getSession() {
            return this.session;
        }

        public String getServletMapping() {
            if (this.path.equals("") || this.path.equals("/")) {
                return "/";
            }
            if (this.path.contains("*")) {
                return this.path;
            }
            if (this.path.endsWith("/")) {
                return this.path + "*";
            }
            return this.path + "/*";
        }

        public String getPath(String path) {
            String prefix = this.getServletPrefix();
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            return prefix + path;
        }

        public String getServletPrefix() {
            String result = this.path;
            int index = result.indexOf(42);
            if (index != -1) {
                result = result.substring(0, index);
            }
            if (result.endsWith("/")) {
                result = result.substring(0, result.length() - 1);
            }
            return result;
        }

        public String[] getPathsArray(Collection<String> paths) {
            String[] result = new String[paths.size()];
            int i = 0;
            for (String path : paths) {
                result[i++] = this.getPath(path);
            }
            return result;
        }

        public String[] getPathsArray(String[] paths) {
            String[] result = new String[paths.length];
            int i = 0;
            for (String path : paths) {
                result[i++] = this.getPath(path);
            }
            return result;
        }
    }

    public static class Compression {
        private boolean enabled = false;
        private String[] mimeTypes = new String[]{"text/html", "text/xml", "text/plain", "text/css", "text/javascript", "application/javascript", "application/json", "application/xml"};
        private String[] excludedUserAgents = null;
        private int minResponseSize = 2048;

        public boolean getEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public String[] getMimeTypes() {
            return this.mimeTypes;
        }

        public void setMimeTypes(String[] mimeTypes) {
            this.mimeTypes = mimeTypes;
        }

        public String[] getExcludedUserAgents() {
            return this.excludedUserAgents;
        }

        public void setExcludedUserAgents(String[] excludedUserAgents) {
            this.excludedUserAgents = excludedUserAgents;
        }

        public int getMinResponseSize() {
            return this.minResponseSize;
        }

        public void setMinResponseSize(int minSize) {
            this.minResponseSize = minSize;
        }
    }
}

