package com.testor.common.constant;

/**
 * 应急预案演练状态
 *
 * @author yizhixiong
 * @date 2022/12/05
 */
public enum RehearsalStatusEnum {

    NOT_START("0", "未开始"),
    WAIT_DISPOSITION("1", "待处置"),
    DISPOSITION_ONGOING("2", "处置中"),
    WAIT_EVALUATE("3", "待评价"),
    COMPLETED("4", "已完成"),
    CLOSE("5", "已关闭"),
    WAITING_FOR_LINKAGE_APPROVAL("6", "待联动审批"),
    LINKAGE_PROCESSING("7", "待联动审批"),
    ;

    RehearsalStatusEnum(String code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    private String code;

    private String msg;

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public static RehearsalStatusEnum getRehearsalStatusByCode(String code) {
        RehearsalStatusEnum[] values = values();
        for (RehearsalStatusEnum value : values) {
            if (value.getCode().equals(code)) {
                return value;
            }
        }
        return null;
    }
    public static RehearsalStatusEnum getRehearsalStatusByMsg(String msg) {
        RehearsalStatusEnum[] values = values();
        for (RehearsalStatusEnum value : values) {
            if (value.getMsg().equals(msg)) {
                return value;
            }
        }
        return null;
    }
}
