package com.testor.module.accident.model.dto;

import com.testor.module.accident.model.domain.AccidentPersonnel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * 事故受伤人员 删除参数对象
 *
 * @author zhangyangfan@testor.com.cn
 * @date 2022-05-11 11:35:33
 */

@Data
@ApiModel(value = "AccidentPersonnel 列表查询参数对象")
@EqualsAndHashCode(callSuper = true)
@NoArgsConstructor
@AllArgsConstructor
public class AccidentPersonnelParam extends AccidentPersonnel {
	private static final long serialVersionUID = 1L;
	@ApiModelProperty(value = "每页数量")
	private String limit;

	@ApiModelProperty(value = "当前页数")
	private String page;

	@ApiModelProperty(value = "排序字段")
	private String orderBy;

	@ApiModelProperty(value = "排序方式")
	private String orderType;

}
