package com.testor.module.contractor.ledger.model.domain;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.testor.common.annotation.Translation;
import com.testor.common.constant.TransConstant;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import org.springframework.format.annotation.DateTimeFormat;


/**
 * 项目台账对象 t_contractor_project
 * 
 * @author testor-framework
 * @date 2024-11-20 09:46:08
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_contractor_project")
@ApiModel(value = "TContractorProject对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TContractorProject extends SuperModel
{
    private static final long serialVersionUID = 1L;
/**
 * id
 */
  @ApiModelProperty(value = "id")

  @TableId("id")
  private String id;
/**
 * 项目名称
 */
  @ApiModelProperty(value = "项目名称")

  @TableField("name")
  private String name;
/**
 * 项目编号
 */
  @ApiModelProperty(value = "项目编号")

  @TableField("code")
  private String code;

  /**
   * 归属企业id
   */
  @ApiModelProperty(value = "归属企业id")

  @TableField("org_id")
  private String orgId;


  /**
 * 项目级别 字典值：contractor_project_level
 */
  @ApiModelProperty(value = "项目级别 字典值：contractor_project_level")

  @TableField("\"level\"")
  @Translation(type = TransConstant.DICT_ID_TO_LABEL)
  private String level;
/**
 * 项目周期 字典值：contractor_project_cycle
 */
  @ApiModelProperty(value = "项目周期 字典值：contractor_project_cycle")

  @TableField("cycle")
  @Translation(type = TransConstant.DICT_ID_TO_LABEL)
  private String cycle;
/**
 * 项目金额（万元）
 */
  @ApiModelProperty(value = "项目金额（万元）")

  @TableField("amount")
  private String amount;
/**
 * 立项时间
 */
  @ApiModelProperty(value = "立项时间")

  @TableField("creation_time")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date creationTime;
/**
 * 项目主管部门
 */
  @ApiModelProperty(value = "项目主管部门")

  @TableField("department_major")
  @Translation(type = TransConstant.ORG_ID_TO_NAME)
  private String departmentMajor;

/**
 * 项目所在部门
 */
  @ApiModelProperty(value = "项目所在部门")

  @TableField("department_belong")
  @Translation(type = TransConstant.ORG_ID_TO_NAME)
  private String departmentBelong;

/**
 * 计划开始时间
 */
  @ApiModelProperty(value = "计划开始时间")

  @TableField("plan_start_time")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date planStartTime;

/**
 * 计划结束时间
 */
  @ApiModelProperty(value = "计划结束时间")

  @TableField("plan_end_time")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date planEndTime;
/**
 * 项目简介
 */
  @ApiModelProperty(value = "项目简介")

  @TableField("introduction")
  private String introduction;

  public static final String ID ="id";
  public static final String NAME ="name";
  public static final String CODE ="code";
  public static final String ORG_ID ="org_id";
  public static final String LEVEL ="\"level\"";
  public static final String CYCLE ="cycle";
  public static final String AMOUNT ="amount";
  public static final String CREATION_TIME ="creation_time";
  public static final String DEPARTMENT_MAJOR ="department_major";
  public static final String DEPARTMENT_BELONG ="department_belong";
  public static final String PLAN_START_TIME ="plan_start_time";
  public static final String PLAN_END_TIME ="plan_end_time";
  public static final String INTRODUCTION ="introduction";


}
