package com.testor.module.contractor.manage.model.domain;

import java.time.LocalDateTime;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.testor.common.annotation.Translation;
import com.testor.common.constant.TransConstant;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import org.springframework.format.annotation.DateTimeFormat;


/**
 * 日常管理-每日工作计划对象 t_contractor_daily_plan
 * 
 * @author testor-framework
 * @date 2024-11-28 15:21:05
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_contractor_daily_plan")
@ApiModel(value = "TContractorDailyPlan对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TContractorDailyPlan extends SuperModel
{
    private static final long serialVersionUID = 1L;
/**
 * 主键id
 */
  @ApiModelProperty(value = "主键id")

  @TableId("id")
  private String id;
/**
 * 承包商台账id
 */
  @ApiModelProperty(value = "承包商台账id")

  @TableField("contractor_id")
  private String contractorId;
/**
 * 项目id
 */
  @ApiModelProperty(value = "项目id")

  @TableField("proj_id")
  private String projId;
/**
 * 业务id(标识是一条基本信息产生的关系)
 */
  @ApiModelProperty(value = "业务id(标识是一条基本信息产生的关系)")

  @TableField("biz_id")
  private String bizId;
/**
 * 流程实例ID
 */
  @ApiModelProperty(value = "流程实例ID")

  @TableField("process_id")
  private String processId;
/**
 * 流程状态
 */
  @ApiModelProperty(value = "流程状态")
  @TableField("process_status")
  private String processStatus;

  @TableField(exist = false)
  @Translation(type = TransConstant.DICT_TYPE_TO_LABEL,other = "contractor_process_status",mapper = "processStatus")
  private String processStatusName;


  /**
   * 机构id
   */
  @ApiModelProperty(value = "机构id")

  @TableField("org_id")
  private String orgId;

/**
 * 作业地点
 */
  @ApiModelProperty(value = "作业地点")

  @TableField("work_site")
  private String workSite;
/**
 * 作业内容
 */
  @ApiModelProperty(value = "作业内容")

  @TableField("work_content")
  private String workContent;
/**
 * 作业开始时间
 */
  @ApiModelProperty(value = "作业开始时间")

  @TableField("work_start_time")
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date workStartTime;
/**
 * 作业结束时间
 */
  @ApiModelProperty(value = "作业结束时间")

  @TableField("work_finish_time")
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date workFinishTime;

  /**
   * 是否危险作业 0否 1是
   */
  @ApiModelProperty(value = "是否危险作业 0否 1是")
  @TableField("is_hazardous_work")
  private String isHazardousWork;

/**
 * 特殊时段
 */
  @ApiModelProperty(value = "特殊时段")

  @TableField("special_period")
  private String specialPeriod;

/**
 * 现场负责人
 */
  @ApiModelProperty(value = "现场负责人")

  @TableField("site_manager")
  private String siteManager;
/**
 * 联系电话
 */
  @ApiModelProperty(value = "联系电话")

  @TableField("tel")
  private String tel;
/**
 * 入场作业人数
 */
  @ApiModelProperty(value = "入场作业人数" , example = "0")

  @TableField("work_pers_num")
  private Long workPersNum;
/**
 * 所在部门id
 */
  @ApiModelProperty(value = "所在部门id")

  @TableField("department_id")
  private String departmentId;

  /**
   * 变更审批Id
   */
  @ApiModelProperty(value = "变更审批Id")
  @TableField("change_process_id")
  private String changeProcessId;

/**
 * 变更审批状态
 */
  @ApiModelProperty(value = "变更审批状态")
  @TableField("change_process_status")
  private String changeProcessStatus;

  @TableField(exist = false)
  @Translation(type = TransConstant.DICT_TYPE_TO_LABEL,other = "contractor_process_status",mapper = "changeProcessStatus")
  private String changeProcessStatusName;

  /**
   * 停/复工审批状态
   */
  @ApiModelProperty(value = "停/复工审批Id")
  @TableField("stop_start_process_id")
  private String stopStartProcessId;

/**
 * 停/复工审批状态
 */
  @ApiModelProperty(value = "停/复工审批状态")
  @TableField("stop_start_process_status")
  private String stopStartProcessStatus;

  @TableField(exist = false)
  @Translation(type = TransConstant.DICT_TYPE_TO_LABEL,other = "contractor_process_status",mapper = "stopStartProcessStatus")
  private String stopStartProcessStatusName;


  /**
   * 作业状态 0未开始 1作业中 2作业关闭 3暂停 4停工 5取消 6删除
   */
  @ApiModelProperty(value = "作业状态 0未开始 1作业中 2作业关闭 3暂停 4停工 5取消")
  @TableField("work_status")
  private String workStatus;

  @TableField(exist = false)
  @Translation(other = "0=--,1=作业中,2=作业关闭,3=暂停,4=停工,5=取消",mapper = "workStatus")
  private String workStatusName;

  @ApiModelProperty(value = "项目名称")
  @TableField(exist = false)
  private String tcontractorProjectName;

  public static final String ID ="id";
  public static final String CONTRACTOR_ID ="contractor_id";
  public static final String PROJ_ID ="proj_id";
  public static final String BIZ_ID ="biz_id";
  public static final String PROCESS_ID ="process_id";
  public static final String PROCESS_STATUS ="process_status";
  public static final String WORK_SITE ="work_site";
  public static final String WORK_CONTENT ="work_content";
  public static final String WORK_START_TIME ="work_start_time";
  public static final String WORK_FINISH_TIME ="work_finish_time";
  public static final String SPECIAL_PERIOD ="special_period";
  public static final String ALLOW_TOOLS_ID ="allow_tools_id";
  public static final String ALLOW_MATERIAL_ID ="allow_material_id";
  public static final String ALLOW_PROTECTIVE_ID ="allow_protective_id";
  public static final String SITE_MANAGER ="site_manager";
  public static final String TEL ="tel";
  public static final String WORK_PERS_NUM ="work_pers_num";
  public static final String DEPARTMENT_ID ="department_id";
  public static final String CHANGE_STATUS ="change_status";
  public static final String STOP_START_STATUS ="stop_start_status";


}
