package com.testor.module.duty.service.impl;

import com.testor.module.duty.model.domain.TSysDuty;
import com.testor.module.duty.model.domain.TSysDutyMonth;
import com.testor.module.duty.model.dto.Person;
import com.testor.module.duty.model.dto.PersonDuty;
import com.testor.module.duty.service.DutyService;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

@Component
@Lazy
public class AsyncDuty {
    @Autowired
    private DutyService dutyService;
    @Async
    public BaseResponse<List<PersonDuty>> returnDutyList(List<TSysDuty> list, TSysDutyMonth one) {
        //按照日期（dd）分组
        Map<String, List<TSysDuty>> collect = list.stream().collect(Collectors.groupingBy(item -> splitDate(item.getDutyDate())));
        List<PersonDuty> duties = new ArrayList<>();

        for (String s : collect.keySet()) {
            //拿到分组后的每一天数据
            List<TSysDuty> tSysDuties = collect.get(s);
            //存储每一天的多个人
            List<Person> people = new ArrayList<>();
            PersonDuty duty = null;
            for (TSysDuty tSysDuty : tSysDuties) {
                duty = BeanHelper.beanToBean(tSysDuty, PersonDuty.class);
                Person person = new Person();
                person.setId(tSysDuty.getId());
                person.setClasses(tSysDuty.getClasses());
                person.setPhone(tSysDuty.getPhone());
                person.setAdjustCause(tSysDuty.getAdjustCause());
                person.setDeptName(tSysDuty.getDeptName());
                person.setName(tSysDuty.getName());
                person.setCreateDate(tSysDuty.getCreateDate());
                person.setIsLeader(tSysDuty.getIsLeader());
                //存储同一天多个人到list
                people.add(person);
                duty.setPersonList(people);
            }
            //按值班模式分组
            Map<String, List<Person>> map = people.stream().collect(Collectors.groupingBy(Person::getClasses));
            //==============
            // 排序后的数据
            Map<String, List<Person>> reMap = new HashMap<>();
            map.keySet().forEach(item -> {
                List<Person> people1 = map.get(item);
                //对分组后的数据按createDate升序排序，并把第一个设置为领导
                List<Person> collect1 = people1.stream().sorted( Comparator.comparing(Person::getCreateDate).thenComparing(Person::getId)).collect(Collectors.toList());
                saveLeader(collect1);
                reMap.put(item, collect1);
            });
            //=========================
            duty.setPersonList(null);
            duty.setMapList(reMap);
            duty.setMorTime(one.getMorTime());
            duty.setLateTime(one.getLateTime());
            duty.setAllTime(one.getAllTime());
            duty.setNoonTime(one.getNoonTime());
            duty.setDutyPattern(one.getDutyPattern());
            duty.setId(one.getId());
            //将同一天数据存到list
            duties.add(duty);
        }
        BaseResponse<List<PersonDuty>> response = new BaseResponse<>();
        response.setData(duties);
        return response;
    }

    private void saveLeader(List<Person> collect1) {
        Map<String, Person> isLeader = collect1.stream().collect(Collectors.toMap(Person::getClasses, Function.identity(), (c1, c2) -> c1));
        //将获取到的每个班次的第一个人保存为领导
        isLeader.keySet().forEach(key -> {
            Person person = isLeader.get(key);
            TSysDuty duty = new TSysDuty();
            duty.setId(person.getId());
            duty.setIsLeader("1");
            dutyService.updateById(duty);
        });
    }
    private String splitDate(String dutyDate) {
        String[] split = dutyDate.split("-");
        String s = split[split.length - 1];
        return s;
    }

}
