package com.testor.module.duty.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.testor.biz.sys.org.model.domain.SysOrg;
import com.testor.biz.sys.org.service.SysOrgService;
import com.testor.module.duty.dao.TSysDutyalterDao;
import com.testor.module.duty.model.domain.TSysDutyalter;
import com.testor.module.duty.model.dto.DutyAlter;
import com.testor.module.duty.service.TSysDutyalterService;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.context.ContextUtils;
import com.tongtech.tfw.backend.common.exception.BusinessException;
import com.tongtech.tfw.backend.common.models.sys.UserInfo;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Objects;

@Service
public class TSysDutyalterServiceImpl extends ServiceImpl<TSysDutyalterDao, TSysDutyalter>  implements TSysDutyalterService {
    @Autowired
    private SysOrgService sysOrgService;
    @Override
    public BaseResponse<BaseResponseList<TSysDutyalter>> getAmendRec(DutyAlter dutyAlter) throws Exception{
        if (ObjectHelper.isEmpty(dutyAlter)) {
            throw new BusinessException("请求参数有误");
        }
        UserInfo loginUser = ContextUtils.getLoginUser();
        SysOrg sysOrg = sysOrgService.getById(loginUser.getOrgId());
        if (Objects.isNull(sysOrg)) {
            throw new BusinessException("当前登录人部门信息不存在，请联系管理员！");
        }
        BaseResponse<BaseResponseList<TSysDutyalter>> baseResponse = new BaseResponse<>();
        Long page =
                StringHelper.isEmpty(dutyAlter.getPage()) ? BizConstants.PAGE : Long.valueOf(dutyAlter.getPage());
        Long limit =
                StringHelper.isEmpty(dutyAlter.getLimit()) ? BizConstants.LIMIT : Long.valueOf(dutyAlter.getLimit());

        Page<TSysDutyalter> resultPage = new Page<>(page, limit);
        QueryWrapper<TSysDutyalter> queryWrapper = this.createQuery(dutyAlter,sysOrg);
        Page<TSysDutyalter> resultList = this.page(resultPage, queryWrapper);
        BaseResponseList<TSysDutyalter> baseResponseList = new BaseResponseList<>();
        baseResponseList.setData(resultList.getRecords());
        baseResponseList.setTotal(resultList.getTotal());
        baseResponse.setData(baseResponseList);
        return baseResponse;
    }

    private QueryWrapper<TSysDutyalter> createQuery(DutyAlter dutyAlter,SysOrg sysOrg) {
        QueryWrapper<TSysDutyalter> queryWrapper = new QueryWrapper<>();
        queryWrapper.orderByDesc("create_date");
        queryWrapper.eq("status", "0");
        if (ObjectHelper.isNotEmpty(dutyAlter.getStartDate()) && ObjectHelper.isNotEmpty(dutyAlter.getEndDate())) {
            queryWrapper.between("duty_date", dutyAlter.getStartDate(),dutyAlter.getEndDate());
        }
        if (ObjectHelper.isNotEmpty(dutyAlter.getUnitBelong())) {
            queryWrapper.eq("unit_belong", dutyAlter.getUnitBelong());
        }else{
            queryWrapper.eq("unit_belong", "本单位");
        }
        if (ObjectHelper.isNotEmpty(dutyAlter.getCompanyId())) {
            queryWrapper.eq("company_id", dutyAlter.getCompanyId());
        }else{
            queryWrapper.eq("company_id", sysOrg.getOrgId());
        }
        if (ObjectHelper.isNotEmpty(dutyAlter.getTenantId())) {
            queryWrapper.eq("tenant_id", dutyAlter.getTenantId());
        }
        // TODO 默认展示哪个租赁公司
        return queryWrapper;
    }
}
