package com.testor.module.hazard.dao;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.module.hazard.model.dto.THazardWorkPlanDetailStatistics;
import com.testor.module.hazard.model.dto.THazardWorkPlanStatistics;
import com.testor.module.hazard.model.vo.HazardWorkPlanStatisticsVO;
import com.testor.module.hazard.model.dto.HazardWorkPlanStatisticsDto;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public interface HazardWorkPlanStatisticsDao {
    /**
     * 危险作业分布统计，根据单位
     * @param param
     * @return
     */
    public List<HazardWorkPlanStatisticsVO> statWorkPlanNumByOrg(@Param("query") HazardWorkPlanStatisticsDto param);

    /**
     * 危险作业数量统计，根据时间
     * @param param
     * @return
     */
    public List<HazardWorkPlanStatisticsVO> statWorkPlanNumByTime(@Param("query") HazardWorkPlanStatisticsDto param);

    /**
     * 相关方作业统计
     * @param param
     * @return
     */
    public List<HazardWorkPlanStatisticsVO> statStakeholderWorkNum(@Param("query") HazardWorkPlanStatisticsDto param);

    /**
     * 租赁库占比统计
     * @param param
     * @return
     */
    public List<HazardWorkPlanStatisticsVO> statIsRentNum(@Param("query") HazardWorkPlanStatisticsDto param);

    /**
     * 危险作业人员统计
     * @param param
     * @return
     */
    public List<HazardWorkPlanStatisticsVO> statOperatorNum(@Param("query") HazardWorkPlanStatisticsDto param);

    /**
     * 危险作业类型统计图表
     * @param hazardWorkPlanStatisticsDto
     * @return
     */
    List<THazardWorkPlanStatistics> selectHazardWorkPlanStatistics(@Param("query") HazardWorkPlanStatisticsDto hazardWorkPlanStatisticsDto);


    /**
     * 危险作业详情基础统计
     * @param query
     * @return
     */
    List<THazardWorkPlanDetailStatistics> workBasicDetailStatistics(@Param("query") HazardWorkPlanStatisticsDto query);

    /**
     * 危险作业详情类别统计
     * @param query
     * @return
     */
    List<THazardWorkPlanDetailStatistics> workTypeDetailStatistics(@Param("query") HazardWorkPlanStatisticsDto query);

    /**
     * 危险作业详情级别统计
     * @param query
     * @return
     */
    List<THazardWorkPlanDetailStatistics> workLevelDetailStatistics(@Param("query") HazardWorkPlanStatisticsDto query);

    /**
     * 危险作业详情状态统计
     * @param query
     * @return
     */
    List<THazardWorkPlanDetailStatistics> workStatusDetailStatistics(@Param("query") HazardWorkPlanStatisticsDto query);

}
