package com.testor.module.hazard.model.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.testor.common.annotation.Translation;
import com.testor.common.constant.TransConstant;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;


/**
 * 危险作业计划对象 t_hazard_work_plan
 * 
 * @author testor-framework
 * @date 2024-12-19 10:39:26
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_hazard_work_plan_check")
@ApiModel(value = "THazardWorkPlanCheck对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class THazardWorkPlanCheck extends SuperModel
{
    private static final long serialVersionUID = 1L;
  /**
  * id
  */
  @ApiModelProperty(value = "id")
  @TableId("id")
  private String id;

  /**
   * 危险作业计划id
   */
  @ApiModelProperty(value = "危险作业计划id")
  private String planId;


  /**
   * 检查时间
   */
  @ApiModelProperty(value = "检查时间")
  @TableField("check_time")
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date checkTime;

  /**
   * 是否合规 0否 1是
   */
  @ApiModelProperty(value = "是否合规 0否 1是")
  @TableField("is_compliant")
  private String isCompliant;

  /**
   * 问题类别 字典id
   */
  @ApiModelProperty(value = "问题类别 字典id")
  @TableField("problem_type")
  private String problemType;

  /**
   * 问题描述
   */
  @ApiModelProperty(value = "问题描述")
  @TableField("check_description")
  private String checkDescription;

  /**
   * 检查图片地址
   */
  @ApiModelProperty(value = "检查图片地址")
  @TableField("check_images")
  private String checkImages;

  /**
   * 检查人签字
   */
  @ApiModelProperty(value = "检查人签字")
  @TableField("check_signature")
  private String checkSignature;

  /**
   * 检查单位
   */
  @ApiModelProperty(value = "检查单位")
  @TableField("check_unit")
  private String checkUnit;

  /**
   * 基层单位
   */
  @ApiModelProperty(value = "基层单位")
  @TableField("basic_unit")
  private String basicUnit;

  /**
   * 检查单位id
   */
  @ApiModelProperty(value = "检查单位id")
  @TableField("check_id")
  private String checkId;

  /**
   * 基层单位id
   */
  @ApiModelProperty(value = "基层单位id")
  @TableField("basic_id")
  private String basicId;

  /**
   * 监督检查状态(1 暂存 2正式)
   */
  @ApiModelProperty(value = "监督检查状态(1 暂存 2已完成)")
  @TableField("check_status")
  private String checkStatus;

  /**
   * 签字时间
   */
  @ApiModelProperty(value = "签字时间")
  @TableField("check_signature_time")
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date checkSignatureTime;

  /**
   * 检查人姓名
   */
  @ApiModelProperty(value = "检查人姓名")
  @TableField("check_name")
  private String checkName;

  /**
   * 作业编号
   */
  @ApiModelProperty(value = "作业编号")
  @TableField(exist = false)
  private String code;

  /**
   * 作业类型
   */
  @ApiModelProperty(value = "作业类型")
  @TableField(exist = false)
  private String workType;

  /**
   * 作业级别
   */
  @ApiModelProperty(value = "作业级别")
  @TableField(exist = false)
  private String workLevel;

  /**
   * 相关方作业
   */
  @ApiModelProperty(value = "相关方作业")
  @TableField(exist = false)
  private String stakeholderWork;





}
