package com.testor.module.mq.service;

import com.testor.biz.sys.org.model.domain.SysOrg;
import com.testor.module.duty.model.dto.TSysDutyLogParam;
import com.testor.module.mq.domain.OrganizationEntity;
import com.testor.module.mq.domain.WeatherDomain;
import com.testor.module.mq.vo.WeatherDetailInfoVO;
import com.testor.module.mq.vo.WeatherWarnInfoVO;
import com.tongtech.tfw.backend.common.models.supers.SuperService;

import java.util.List;

public interface WeatherService extends SuperService<WeatherDomain> {
    List<WeatherWarnInfoVO> getWarnList(String orgId);

    /**
     * @description TODO 获取添加工作日志天气
     * @param addRequest
     * @param sysOrg
     * @return void
     * @author qiao
     * @date 4/13/23 11:27 AM
     */
    List<WeatherWarnInfoVO> getWarnListLog(TSysDutyLogParam addRequest, SysOrg sysOrg);

    List<OrganizationEntity> getOrganizationEntities(String pages,String limits);

    /**
     * @description 获取天气详情
     * @param id
     * @return
     */
    WeatherDetailInfoVO findWeatherDetail(String id);

    List<SysOrg> findWaringOrgList(String senderAreaCode);

    /**
     * 给受影响的单位下的人员推送气象预警信息
     * @param weatherDomain
     */
    void pushWeatherWarningMsg(WeatherDomain weatherDomain);



}
