package com.testor.module.train.myManagement.dao;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.module.train.myManagement.model.domain.TTrainTestQuestionsExercise;
import com.testor.module.train.myManagement.model.dto.TTrainTestQuestionsExerciseParam;
import com.tongtech.tfw.backend.common.models.supers.SuperDao;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 我的试题练习、考试—安全培训教育Mapper接口
 *
 * @author testor-framework
 * @date 2022-08-08 10:16:57
 */
public interface TTrainTestQuestionsExerciseDao extends SuperDao<TTrainTestQuestionsExercise> {
    IPage<TTrainTestQuestionsExercise> errorRecord(Page<TTrainTestQuestionsExercise> resultPage,@Param("param") TTrainTestQuestionsExerciseParam param ,@Param("userId") String userId);


    /**
     * 根据考试id查询补考记录
     * @param id 考试id
     * @param userId 用户id
     * @return
     */
    List<TTrainTestQuestionsExercise> getByExaminationId(@Param("id") String id,@Param("userId") String userId);

    @Select("select * from t_train_test_questions_exercise\n" +
            "where my_id = #{id} and create_by = #{createBy} and status = '0' and parent_id is not null")
    List<TTrainTestQuestionsExercise> getByMyIdAndCreateBy(@Param("id") String id,@Param("createBy") String createBy);

}
