package com.testor.module.train.project.service;

import com.alibaba.fastjson.JSONObject;
import com.testor.module.train.myManagement.model.dto.TTrainMyManagementParam;
import com.testor.module.train.project.model.stat.*;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;
import java.util.Map;

/**
 * @author caq
 * @date 2024/9/7
 * @description 个人培训档案列表
 */
public interface TrainProjectUserService {

    /**
     * 获取个人培训 指标下拉框列表
     * @return
     */
    Map<String, List<JSONObject>> professionalIndicatorScoreSelect();


    /**
     * 个人培训档案列表
     * @param param
     * @return
     */
    BaseResponseList<TrainProjectUserListVo> findProjectUserPageList(TrainProjectUserPara param);


    /**
     * 个人培训档案统计
     * @param userId
     * @return
     */
    TrainProjectUserStat findProjectUserStat(String  userId);

    /**
     * 个人培训档案信息
     * @param userId
     * @return
     */
    ProjectUserInfo findProjectUserInfo(String  userId);


    List<TrainProjectUserDetailStat> findTrainList(TTrainMyManagementParam param) ;


}