/*
 * Decompiled with CFR 0.152.
 */
package com.testor.biz.helper;

import com.testor.biz.file.FileTypeEnum;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.io.FileHelper;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.activation.MimetypesFileTypeMap;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonHelper {
    private static final Logger log = LoggerFactory.getLogger(CommonHelper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fileDownload(String fileName, String filePath, HttpServletResponse response) throws UnsupportedEncodingException {
        String type = new MimetypesFileTypeMap().getContentType(fileName);
        String encodeFileName = URLEncoder.encode(fileName, "UTF-8");
        encodeFileName = StringHelper.replace((String)encodeFileName, (String)"+", (String)"%20");
        response.setHeader("Content-type", type);
        response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
        response.setHeader("Content-Disposition", "attachment;filename=" + encodeFileName);
        ServletOutputStream outputStream = null;
        BufferedInputStream bis = null;
        try {
            outputStream = response.getOutputStream();
            byte[] buff = new byte[1024];
            File localFile = FileHelper.file((String)filePath);
            response.setContentLength((int)localFile.length());
            bis = new BufferedInputStream(new FileInputStream(localFile));
            int i = bis.read(buff);
            while (i != -1) {
                outputStream.write(buff, 0, i);
                outputStream.flush();
                i = bis.read(buff);
            }
        }
        catch (IOException e) {
            log.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff01\u6587\u4ef6\u4e3a{}", (Object)fileName, (Object)e);
        }
        finally {
            try {
                if (null != outputStream) {
                    outputStream.close();
                }
                if (null != bis) {
                    bis.close();
                }
            }
            catch (IOException e) {
                log.error("close io error....", (Throwable)e);
            }
        }
    }

    public static boolean checkFileType(byte[] fileContent, String ext) {
        for (FileTypeEnum fileTypeEnum : FileTypeEnum.values()) {
            if (!ext.endsWith(fileTypeEnum.getKeyWords())) continue;
            Integer length = fileTypeEnum.getLength();
            String header = fileTypeEnum.getHeader();
            StringBuilder received = new StringBuilder();
            for (int i = 0; i < length / 2; ++i) {
                received.append(Integer.toHexString(fileContent[i] & 0xFF));
            }
            if (received.toString().toUpperCase().equals(header)) continue;
            return false;
        }
        return true;
    }
}

