package com.testor.config.aspect;

import lombok.RequiredArgsConstructor;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.flowable.app.engine.AppEngineConfiguration;
import org.springframework.stereotype.Component;

@Aspect
@Component
@RequiredArgsConstructor
public class KingbaseSupport {

    private final AppEngineConfiguration appEngineConfiguration;

    @Pointcut("execution(* org.flowable.app.engine.AppEngineConfiguration.buildAppEngine())")
    public void access() {

    }

    @Before("access()")
    public void before() {
        appEngineConfiguration.setDatabaseType("mysql");
    }
}


