package com.testor.ddd.safetyControl.infrastructure.repository.riskPointSource.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;


/**
 * 风险点-危险源关联关系对象 t_safe_risk_point_source
 * 
 * @author testor-framework
 * @date 2022-07-20 14:18:13
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_safe_risk_point_source")
@ApiModel(value = "TSafeRiskPointSource对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TSafeRiskPointSourceDO extends SuperModel
{
    private static final long serialVersionUID = 1L;
/**
 * id
 */
  @ApiModelProperty(value = "id")
  @TableId(value = "id",type = IdType.ASSIGN_UUID)
  private String id;
/**
 * 组织机构id
 */
  @ApiModelProperty(value = "组织机构id")

  @TableField("org_id")
  private String orgId;
/**
 * 风险点id
 */
  @ApiModelProperty(value = "风险点id")

  @TableField("point_id")
  private String pointId;
/**
 * 危险源id
 */
  @ApiModelProperty(value = "危险源id")

  @TableField("source_id")
  private String sourceId;

  public static final String ID ="id";
  public static final String ORG_ID ="org_id";
  public static final String POINT_ID ="point_id";
  public static final String SOURCE_ID ="source_id";


}
