package com.testor.module.contractor.manage.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.module.contractor.ledger.service.TContractorPersonService;
import com.testor.module.contractor.manage.model.domain.TContractorConditionReviewDetail;
import com.testor.module.contractor.manage.model.dto.ConditionReviewContentDto;
import com.testor.module.contractor.manage.model.dto.TContractorConditionReviewDetailDelParam;
import com.testor.module.contractor.manage.model.dto.TContractorConditionReviewDetailParam;
import com.testor.module.contractor.manage.service.*;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

/**
 * 承包商管理-条件审查-审查内容Controller
 *
 * @author testor-framework
 * @date 2024-11-26 10:33:15
 */
@RestController
@RequestMapping("/contractorManage/conditionReviewDetail")
@Api(value = "TContractorConditionReviewDetail", tags = "承包商管理-条件审查-审查内容")
@Slf4j
public class TContractorConditionReviewDetailController extends SuperController
{
    @Autowired
    private TContractorConditionReviewDetailService tContractorConditionReviewDetailService;

	@Autowired
	private TContractorAllowService tContractorAllowService;
	@Autowired
	private TContractorAllowPersonService tContractorAllowPersonService;
	@Autowired
	private TContractorPersonService tContractorPersonService;

	@Autowired
	private TContractorAllowProtectiveService tContractorAllowProtectiveService;

	@Autowired
	private TContractorPreparationService tContractorPreparationService;

	@Autowired
	private TContractorConditionReviewService tContractorConditionReviewService;

    /* Generated Method*/
	@ApiOperation(value = "新增 承包商管理-条件审查-审查内容", notes = "Add TContractorConditionReviewDetail")
	@PostMapping(value = "/add")
	public BaseResponse<TContractorConditionReviewDetail>addEntity(@RequestBody TContractorConditionReviewDetail addRequest) {
		BaseResponse<TContractorConditionReviewDetail> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(addRequest)){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
			String id = IdHelper.getId32bit();
            TContractorConditionReviewDetail data=BeanHelper.beanToBean(addRequest,  TContractorConditionReviewDetail.class);
			data.setId(id);
			boolean result= tContractorConditionReviewDetailService.save(data);
			if(result){
                TContractorConditionReviewDetail newEntity = new TContractorConditionReviewDetail();
				newEntity.setId(id);
				baseResponse.setData(newEntity);
			}
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 承包商管理-条件审查-审查内容 ", notes = "Get TContractorConditionReviewDetail By Id")
	@GetMapping(value = "/get")
	public BaseResponse<TContractorConditionReviewDetail> getById(String id){
		BaseResponse<TContractorConditionReviewDetail> baseResponse=new BaseResponse<>();
		if(StringHelper.isNotEmpty(id)){
			// TODO 按需求添加业务异常判断
            TContractorConditionReviewDetail data= tContractorConditionReviewDetailService.getById(id);
			baseResponse.setData(data);
		}
		return baseResponse;
	}

	@ApiOperation(value = "修改 承包商管理-条件审查-审查内容 ", notes = "Update TContractorConditionReviewDetail By Id")
	@PutMapping(value = "/update")
	public BaseResponse<BizGeneralResponse> updateEntity(@RequestBody TContractorConditionReviewDetail updateRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(updateRequest)&&StringHelper.isNotEmpty(updateRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
            TContractorConditionReviewDetail data=BeanHelper.beanToBean(updateRequest, TContractorConditionReviewDetail.class);
			boolean result= tContractorConditionReviewDetailService.updateById(data);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "删除 承包商管理-条件审查-审查内容 ", notes = "delete TContractorConditionReviewDetail By Id")
	@PutMapping(value = "/delete")
	public BaseResponse<BizGeneralResponse> deleteEntity(@RequestBody TContractorConditionReviewDetailDelParam deleteRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(deleteRequest)&&StringHelper.isNotEmpty(deleteRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
            TContractorConditionReviewDetail data= new TContractorConditionReviewDetail();
			data.setId(deleteRequest.getId());
			data.setStatus(BizConstants.STATUS_DELETE);
			boolean result= tContractorConditionReviewDetailService.updateById(data);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "批量删除承包商管理-条件审查-审查内容", notes = "delete TContractorConditionReviewDetail by batch Id")
	@PutMapping(value = "/batch_delete")
	public BaseResponse<BizGeneralResponse> deleteEntityBatch(
			@RequestBody TContractorConditionReviewDetailDelParam deleteRequest) {
		BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
		if (ObjectHelper.isNotEmpty(deleteRequest) && (!deleteRequest.getIds().isEmpty())) {
            /* 批量删除 */
			List<TContractorConditionReviewDetail> tContractorConditionReviewDetailList = new ArrayList<>();
            for(String id: deleteRequest.getIds()){
                TContractorConditionReviewDetail data= new TContractorConditionReviewDetail();
				data.setId(id);
				data.setStatus(BizConstants.STATUS_DELETE);
                tContractorConditionReviewDetailList.add(data);
			}
			boolean result = tContractorConditionReviewDetailService.updateBatchById(tContractorConditionReviewDetailList);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 承包商管理-条件审查-审查内容 分页列表", notes = "List TContractorConditionReviewDetail with page")
	@GetMapping(value = "/list")
	public  BaseResponse<BaseResponseList<TContractorConditionReviewDetail>>listEntity(TContractorConditionReviewDetailParam param){
		BaseResponse<BaseResponseList<TContractorConditionReviewDetail>>baseResponse=new BaseResponse<>();
		Long page=
				StringHelper.isEmpty(param.getPage())?BizConstants.PAGE:Long.valueOf(param.getPage());
		Long limit=
				StringHelper.isEmpty(param.getLimit())?BizConstants.LIMIT:Long.valueOf(param.getLimit());
		Page<TContractorConditionReviewDetail> resultPage=new Page<>(page,limit);
		// TODO 根据需求修改查询条件及查询参数
		QueryWrapper<TContractorConditionReviewDetail> queryWrapper=this.createQuery(param);
		Page<TContractorConditionReviewDetail> resultList= tContractorConditionReviewDetailService.page(resultPage,queryWrapper);
		BaseResponseList<TContractorConditionReviewDetail> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList.getRecords());
		baseResponseList.setTotal(resultList.getTotal());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

	@ApiOperation(value = "获取 承包商管理-条件审查-审查内容 列表", notes = "List TContractorConditionReviewDetail all")
	@GetMapping(value = "/datas")
	public  BaseResponse<BaseResponseList<TContractorConditionReviewDetail>>listAllEntity(TContractorConditionReviewDetailParam param){
		BaseResponse<BaseResponseList<TContractorConditionReviewDetail>>baseResponse=new BaseResponse<>();
		// TODO 根据需求修改查询条件及查询参数
		QueryWrapper<TContractorConditionReviewDetail> queryWrapper=this.createQuery(param);
		List<TContractorConditionReviewDetail> resultList=tContractorConditionReviewDetailService.list(queryWrapper);
		BaseResponseList<TContractorConditionReviewDetail> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList);
		baseResponseList.setTotal(resultList.size());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

	@ApiOperation(value = "获取 承包商管理-条件审查-审查内容 条件确认聚合信息", notes = "List TContractorConditionReviewDetail Confirm info")
	@GetMapping(value = "/conditionConfirmInfo")
	public BaseResponse<ConditionReviewContentDto> conditionConfirmInfo(TContractorConditionReviewDetailParam param){
		BaseResponse<ConditionReviewContentDto>baseResponse=new BaseResponse<>();
		ConditionReviewContentDto dto = tContractorConditionReviewDetailService.getReviewContent(param);
		baseResponse.setData(dto);
        return baseResponse;
	}

    /* Private Methods */
	/**
     * 列表查询条件及查询参数
     */
	private QueryWrapper<TContractorConditionReviewDetail> createQuery(TContractorConditionReviewDetailParam queryParam){
		QueryWrapper<TContractorConditionReviewDetail> queryWrapper=new QueryWrapper<>();
		if(StringHelper.isNotEmpty(queryParam.getReviewId())){
			queryWrapper.eq(TContractorConditionReviewDetail.REVIEW_ID,queryParam.getReviewId());
		}
		if(StringHelper.isNotEmpty(queryParam.getContent())){
			queryWrapper.eq(TContractorConditionReviewDetail.CONTENT,queryParam.getContent());
		}
		if(StringHelper.isNotEmpty(queryParam.getOtherContent())){
			queryWrapper.eq(TContractorConditionReviewDetail.OTHER_CONTENT,queryParam.getOtherContent());
		}
		if(StringHelper.isNotEmpty(queryParam.getCode())){
			queryWrapper.eq(TContractorConditionReviewDetail.CODE,queryParam.getCode());
		}
		if(StringHelper.isNotEmpty(queryParam.getReviewStatus())){
			queryWrapper.eq(TContractorConditionReviewDetail.REVIEW_STATUS,queryParam.getReviewStatus());
		}
		if(StringHelper.isNotEmpty(queryParam.getIsCompliant())){
			queryWrapper.eq(TContractorConditionReviewDetail.IS_COMPLIANT,queryParam.getIsCompliant());
		}
		if (StringHelper.isNotEmpty(queryParam.getStatus())) {
			queryWrapper.eq(TContractorConditionReviewDetail.STATUS, queryParam.getStatus());
		} else {
			queryWrapper.ne(TContractorConditionReviewDetail.STATUS, BizConstants.STATUS_DELETE);
		}
		if (StringHelper.isNotEmpty(queryParam.getOrderBy())){
			if(StringHelper.isNotEmpty(queryParam.getOrderType())
					&&BizConstants.ASC.equals(queryParam.getOrderType())){
				queryWrapper.orderByAsc(queryParam.getOrderBy());
			}else{
				queryWrapper.orderByDesc(queryParam.getOrderBy());
			}
		}else{
			queryWrapper.orderByAsc(TContractorConditionReviewDetail.TREE_SORT);
		}
		return queryWrapper;
	}
}
