package com.testor.module.iam.service.impl;

import com.testor.common.constant.IamMessageStatusEnum;
import com.testor.module.iam.dao.IamMessageDao;
import com.testor.module.iam.model.domain.IamMessage;
import com.testor.module.iam.service.IamDepartmentService;
import com.testor.module.iam.service.IamMessageService;
import com.testor.module.iam.service.IamSysUserService;
import com.tongtech.tfw.backend.common.models.supers.SuperServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.Date;

/**
 * @ClassName: IamMessageServiceImpl
 * @Description: TODO
 * @Author: lm
 * @CreateTime: 2024/1/2 14:12
 * @Version: 1.0
 */
@Service("IamMessageServiceImpl")
public class IamMessageServiceImpl extends SuperServiceImpl<IamMessageDao,IamMessage> implements IamMessageService {

    @Autowired
    private IamDepartmentService iamDepartmentService;

    @Autowired
    private IamSysUserService iamSysUserService;

    @Override
    public boolean push(IamMessage iamMessage) {
        boolean flag = false;
        if (add(iamMessage)){
            flag = handleMessage(iamMessage);
            if (flag) {
                iamMessage.setStatus(IamMessageStatusEnum.SUCCESS.getCode());
            } else {
                iamMessage.setStatus(IamMessageStatusEnum.FAIL.getCode());
            }
            iamMessage.setUpdateDate(new Date());
            updateById(iamMessage);
        }
        return flag;
    }

    @Override
    public boolean add(IamMessage iamMessage) {
        iamMessage.setCreateDate(new Date());
        iamMessage.setStatus(IamMessageStatusEnum.NEW.getCode());
        return save(iamMessage);
    }

    @Override
    public boolean handleMessage(IamMessage iamMessage) {
        boolean flag = false;
        switch (iamMessage.getDataType()){
            case "USER":
                flag = iamSysUserService.handleMessage(iamMessage);
                break;
            case "DEPARTMENT":
                flag = iamDepartmentService.handleMessage(iamMessage);
                break;
            default:
                break;
        }
        return flag;
    }
}
