package com.testor.module.safe.model.enums;


import lombok.Getter;

@Getter
public enum HazardLevelEnum {
    MAJOR("2", "重大不符合项"),
    GENERAL("1", "一般不符合项"),
    LARGER("3", "较大不符合项");

    private final String code;
    private final String msg;

    HazardLevelEnum(String code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    @Override
    public String toString() {
        return msg;
    }

    public static String getCodeByMsg(String msg) {
        for (HazardLevelEnum level : HazardLevelEnum.values()) {
            if (level.getMsg().equals(msg)) {
                return level.getCode();
            }
        }
        throw new IllegalArgumentException("Invalid msg: " + msg);
    }

    public static HazardLevelEnum fromCode(String code) {
        for (HazardLevelEnum level : HazardLevelEnum.values()) {
            if (level.getCode().equals(code)) {
                return level;
            }
        }
        throw new IllegalArgumentException("Invalid code: " + code);
    }
}

