package com.testor.module.train.course.model.dto;

import com.testor.module.train.course.model.domain.TTrainSection;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 课程章节—安全培训教育 删除参数对象
 *
 * @author testor-framework
 * @date 2022-07-25 18:03:44
 */

@Data
@ApiModel(value = "TTrainSection 列表查询参数对象")
@EqualsAndHashCode(callSuper = true)
public class TTrainSectionParam extends TTrainSection {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value = "每页数量")
    private String limit;

    @ApiModelProperty(value = "当前页数")
    private String page;

    @ApiModelProperty(value = "排序字段")
    private String orderBy;

    @ApiModelProperty(value = "排序方式")
    private String orderType;

    @ApiModelProperty(value = "章节进度")
    private String sectionPlan;

    @ApiModelProperty(value = "多个小节")
    private List<TTrainSmallNodeParam> tTrainSmallNodes;
}
