package com.testor.module.video.model.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.util.List;

@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_video_equipment_info")
@ApiModel(value = "视频监控实体对象", description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class VideoEquipmentInfo extends SuperModel {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId("id")
    private String id;

    @ApiModelProperty(value = "粮库id")
    @TableField("org_id")
    private String orgId;

    @ApiModelProperty("粮库名称")
    @TableField("org_name")
    private String orgName;

    @ApiModelProperty("设备名称")
    @TableField("equipment_name")
    private String equipmentName;

    @ApiModelProperty("安装位置")
    @TableField("installation_location")
    private String installationLocation;

    @ApiModelProperty("设备国标id")
    @TableField("device_id")
    private String deviceId;

    @ApiModelProperty("监控位置，多个用逗号隔开")
    @TableField("monitor_location")
    private String monitorLocation;
    @ApiModelProperty("监控位置名称，多个区域")
    @TableField(exist = false)
    private List<String> monitorLocationName;

    @ApiModelProperty("是否盯防，1盯防，0正常")
    @TableField("is_eye")
    private Integer isEye;

    @ApiModelProperty("空间场所id")
    @TableField("space_id")
    private String spaceId;

    @ApiModelProperty("空间场所类型id")
    @TableField("space_type_id")
    private String spaceTypeId;

    @ApiModelProperty("通道地址")
    @TableField(exist = false)
    private String channelUrl;
}
