/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tfw.workflow.apis.history.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.workflow.apis.history.model.dto.ProcessHisInsListRequest;
import com.tongtech.tfw.workflow.apis.history.model.dto.ProcessHisInsListResponse;
import com.tongtech.tfw.workflow.apis.instance.model.domain.ActHiProcinst;
import com.tongtech.tfw.workflow.apis.instance.service.ActHiProcinstService;
import com.tongtech.tfw.workflow.apis.user.service.ActIdUserService;
import com.tongtech.tfw.workflow.service.TfwCommonService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(value="ProcessHistory Controller", tags={"WF\u6d41\u7a0b\u5386\u53f2\u7ba1\u7406"})
@RequestMapping(value={"/wf/history"})
public class HistoryController {
    private static final Logger log = LoggerFactory.getLogger(HistoryController.class);
    @Autowired
    private ActHiProcinstService actHiProcinstService;
    @Autowired
    private ActIdUserService actIdUserService;
    @Autowired
    private TfwCommonService tfwCommonService;

    @ApiOperation(value="\u7ed3\u675f\u7684\u6d41\u7a0b\u5217\u8868", notes="List Process Instance Finished")
    @GetMapping(value={"/process-instance/list"})
    public BaseResponse<BaseResponseList<ProcessHisInsListResponse>> processInsList(ProcessHisInsListRequest processHisInsListRequest) {
        BaseResponse baseResponse = new BaseResponse();
        Long page = StringHelper.isEmpty((CharSequence)processHisInsListRequest.getPage()) ? BizConstants.PAGE : Long.valueOf(processHisInsListRequest.getPage());
        Long limit = StringHelper.isEmpty((CharSequence)processHisInsListRequest.getLimit()) ? BizConstants.LIMIT : Long.valueOf(processHisInsListRequest.getLimit());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.isNotNull((Object)"END_TIME_");
        if (StringHelper.isNotBlank((CharSequence)processHisInsListRequest.getInstanceId())) {
            queryWrapper.eq((Object)"PROC_INST_ID_", (Object)processHisInsListRequest.getInstanceId());
        }
        if (StringHelper.isNotBlank((CharSequence)processHisInsListRequest.getProcessDefinitionName())) {
            queryWrapper.in((Object)"PROC_DEF_ID_", this.tfwCommonService.queryDefId(processHisInsListRequest.getProcessDefinitionName()));
        }
        if (StringHelper.isNotBlank((CharSequence)processHisInsListRequest.getStartUser())) {
            queryWrapper.in((Object)"START_USER_ID_", this.tfwCommonService.queryUserIds(processHisInsListRequest.getStartUser()));
        }
        queryWrapper.orderByDesc((Object)"START_TIME_");
        Page resultPage = new Page(page.longValue(), limit.longValue());
        Page resultList = (Page)this.actHiProcinstService.page((IPage)resultPage, (Wrapper)queryWrapper);
        ArrayList<ProcessHisInsListResponse> result = new ArrayList<ProcessHisInsListResponse>(resultList.getRecords().size());
        for (ActHiProcinst actHiProcinst : resultList.getRecords()) {
            ProcessHisInsListResponse processHisInsListResponse = new ProcessHisInsListResponse(actHiProcinst);
            processHisInsListResponse.setStartUser(this.tfwCommonService.queryUserName(processHisInsListResponse.getStartUser()));
            processHisInsListResponse.setProcessDefinitionName(this.tfwCommonService.queryDefName(processHisInsListResponse.getProcessDefinitionId()));
            result.add(processHisInsListResponse);
        }
        BaseResponseList responseListBaseResponse = new BaseResponseList();
        responseListBaseResponse.setData(result);
        responseListBaseResponse.setTotal((long)result.size());
        baseResponse.setData((Object)responseListBaseResponse);
        return baseResponse;
    }
}

