/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tfw.backend.core.helper.datetime;

import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.datetime.TemporalAccessorHelper;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.Objects;

public class DatetimeHelper {
    public static LocalDateTime of(Instant instant, ZoneId zoneId) {
        if (null == instant) {
            return null;
        }
        return LocalDateTime.ofInstant(instant, ObjectHelper.defaultIfNull(zoneId, ZoneId.systemDefault()));
    }

    public static LocalDateTime of(Instant instant) {
        return DatetimeHelper.of(instant, ZoneId.systemDefault());
    }

    public static LocalDateTime of(TemporalAccessor temporalAccessor) {
        if (null == temporalAccessor) {
            return null;
        }
        if (temporalAccessor instanceof LocalDate) {
            return ((LocalDate)temporalAccessor).atStartOfDay();
        }
        return LocalDateTime.of(TemporalAccessorHelper.get(temporalAccessor, ChronoField.YEAR), TemporalAccessorHelper.get(temporalAccessor, ChronoField.MONTH_OF_YEAR), TemporalAccessorHelper.get(temporalAccessor, ChronoField.DAY_OF_MONTH), TemporalAccessorHelper.get(temporalAccessor, ChronoField.HOUR_OF_DAY), TemporalAccessorHelper.get(temporalAccessor, ChronoField.MINUTE_OF_HOUR), TemporalAccessorHelper.get(temporalAccessor, ChronoField.SECOND_OF_MINUTE), TemporalAccessorHelper.get(temporalAccessor, ChronoField.NANO_OF_SECOND));
    }

    public static LocalDateTime ofUTC(Instant instant) {
        return DatetimeHelper.of(instant, ZoneId.of("UTC"));
    }

    public static LocalDateTime ofCTT(Instant instant) {
        return DatetimeHelper.of(instant, ZoneId.of(ZoneId.SHORT_IDS.get("CTT")));
    }

    public static LocalDateTime of(Date date, ZoneId zoneId) {
        if (null == date) {
            return null;
        }
        if (null == zoneId) {
            return DatetimeHelper.of(date.toInstant());
        }
        return DatetimeHelper.of(date.toInstant(), zoneId);
    }

    public static LocalDateTime of(long timestamp, ZoneId zoneId) {
        Instant instant = Instant.ofEpochMilli(timestamp);
        return LocalDateTime.ofInstant(instant, ObjectHelper.defaultIfNull(zoneId, ZoneId.systemDefault()));
    }

    public static LocalDateTime of(long timestamp) {
        return DatetimeHelper.of(timestamp, ZoneId.systemDefault());
    }

    public static LocalDateTime ofUTC(long timestamp) {
        return DatetimeHelper.of(timestamp, ZoneId.of("UTC"));
    }

    public static LocalDateTime ofTCC(long timestamp) {
        return DatetimeHelper.of(timestamp, ZoneId.of(ZoneId.SHORT_IDS.get("CTT")));
    }

    public static LocalDateTime parse(CharSequence dateTime, DateTimeFormatter dateTimeFormatter) {
        if (null == dateTime) {
            return null;
        }
        if (null == dateTimeFormatter) {
            return LocalDateTime.parse(dateTime);
        }
        return DatetimeHelper.of(dateTimeFormatter.parse(dateTime));
    }

    public static LocalDateTime parse(CharSequence dateTime, String format) {
        if (null == dateTime) {
            return null;
        }
        DateTimeFormatter dateTimeFormatter = null;
        if (StringHelper.isNotBlank(format)) {
            if (StringHelper.startWithIgnoreCase(format, "yyyyMMdd") && !format.contains(".")) {
                String fraction = StringHelper.removePrefix(format, "yyyyMMdd");
                if (3 > fraction.length()) {
                    dateTime = dateTime + StringHelper.repeat('0', 3 - fraction.length());
                }
                dateTimeFormatter = new DateTimeFormatterBuilder().appendPattern("yyyyMMdd").appendValue(ChronoField.MILLI_OF_SECOND, 3).toFormatter();
            } else {
                dateTimeFormatter = DateTimeFormatter.ofPattern(format);
            }
        }
        return DatetimeHelper.parse(dateTime, dateTimeFormatter);
    }

    public static LocalDateTime parse(CharSequence dateTime) {
        return DatetimeHelper.parse(dateTime, "yyyy-MM-dd HH:mm:ss");
    }

    public static LocalDate ofDate(TemporalAccessor temporalAccessor) {
        if (null == temporalAccessor) {
            return null;
        }
        if (temporalAccessor instanceof LocalDateTime) {
            return ((LocalDateTime)temporalAccessor).toLocalDate();
        }
        return LocalDate.of(TemporalAccessorHelper.get(temporalAccessor, ChronoField.YEAR), TemporalAccessorHelper.get(temporalAccessor, ChronoField.MONTH_OF_YEAR), TemporalAccessorHelper.get(temporalAccessor, ChronoField.DAY_OF_MONTH));
    }

    public static LocalDate parseDate(CharSequence date, DateTimeFormatter dateTimeFormatter) {
        if (null == date) {
            return null;
        }
        if (null == dateTimeFormatter) {
            return LocalDate.parse(date);
        }
        return DatetimeHelper.ofDate(dateTimeFormatter.parse(date));
    }

    public static LocalDate parseDate(CharSequence date, String format) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format);
        return LocalDate.parse(date, formatter);
    }

    public static LocalDate parseDate(CharSequence date) {
        return DatetimeHelper.parseDate(date, "yyyy-MM-dd");
    }

    public static LocalDateTime afterSpecifiedTimeGap(LocalDateTime base, long gap, ChronoUnit timeUnit) {
        LocalDateTime result = null;
        if (Objects.nonNull(base)) {
            if (Objects.isNull(timeUnit)) {
                timeUnit = ChronoUnit.SECONDS;
            }
            result = base.plus(gap, timeUnit);
        }
        return result;
    }

    public static LocalDateTime afterSpecifiedTimeGap(long baseTs, long gap, ChronoUnit timeUnit) {
        LocalDateTime base = DatetimeHelper.of(baseTs);
        return DatetimeHelper.afterSpecifiedTimeGap(base, gap, timeUnit);
    }

    public static boolean isAfterComparedDayGaps(LocalDate given, LocalDate compare, long gap) {
        LocalDate localDate = compare.minusDays(gap);
        return given.isAfter(localDate);
    }

    public static boolean isEqualComparedDayGaps(LocalDate given, LocalDate compare, long gap) {
        LocalDate localDate = compare.minusDays(gap);
        return given.isEqual(localDate);
    }

    public static boolean isBeforeSecondLDt(LocalDateTime firstTime, LocalDateTime secondTime) {
        Duration duration = Duration.between(firstTime, secondTime);
        long nano = duration.toNanos();
        return 0L <= nano;
    }

    public static LocalDateTime getTodayStartTime() {
        return LocalDateTime.now().with(LocalTime.MIN);
    }

    public static LocalDateTime getTodayEndTime() {
        return LocalDateTime.now().with(LocalTime.MAX);
    }

    public static String getCurrentHour24Format() {
        return DatetimeHelper.getGivenHour24Format(LocalDateTime.now());
    }

    public static String getGivenHour24Format(LocalDateTime localDateTime) {
        return "" + localDateTime.getHour();
    }

    public static String getDateTime26Length() {
        return DatetimeHelper.toString(LocalDateTime.now(), "yyyy-MM-dd+HH:mm:ss.SSSSSS");
    }

    public static String getDateTime8Length() {
        return DatetimeHelper.toString(LocalDateTime.now(), "yyyyMMdd");
    }

    public static String getDate() {
        return DatetimeHelper.toString(LocalDateTime.now(), "yyyy-MM-dd HH:mm:ss");
    }

    public static String toString(LocalDateTime localDateTime, String Pattern2) {
        return localDateTime.format(DateTimeFormatter.ofPattern(Pattern2));
    }

    public static String toString(LocalDateTime localDateTime) {
        return DatetimeHelper.toString(localDateTime, "yyyy-MM-dd HH:mm:ss");
    }

    public static long toTimestamp(LocalDateTime localDateTime) {
        return DatetimeHelper.toTimestamp(localDateTime, ZoneId.systemDefault());
    }

    public static long toTimestamp(LocalDateTime localDateTime, ZoneId zoneId) {
        return localDateTime.atZone(ObjectHelper.defaultIfNull(zoneId, ZoneId.systemDefault())).toInstant().toEpochMilli();
    }
}

