/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tfw.backend.core.helper.io;

import com.tongtech.tfw.backend.core.helper.io.file.FileOperator;
import com.tongtech.tfw.backend.core.models.exceptions.FrameworkException;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;

public class FileHelper {
    public static byte[] readBytes(File file) throws FrameworkException {
        return FileOperator.build(file).readBytes();
    }

    public static byte[] readBytes(String filePath) throws FrameworkException {
        return FileHelper.readBytes(FileHelper.file(filePath));
    }

    public static File writeBytes(byte[] data, File dest) throws FrameworkException {
        return FileHelper.writeBytes(data, dest, 0, data.length, false);
    }

    public static File writeBytes(byte[] data, File dest, int off, int len, boolean isAppend) throws FrameworkException {
        return FileOperator.build(dest).write(data, off, len, isAppend);
    }

    public static File file(String path) {
        if (null == path) {
            return null;
        }
        return new File(path);
    }

    public static File touch(File file) throws FrameworkException {
        if (null == file) {
            return null;
        }
        if (!file.exists()) {
            FileHelper.mkParentDirs(file);
            try {
                file.createNewFile();
            }
            catch (Exception e) {
                throw new FrameworkException(e);
            }
        }
        return file;
    }

    public static File mkParentDirs(File file) {
        File parentFile = file.getParentFile();
        if (null != parentFile && !parentFile.exists()) {
            parentFile.mkdirs();
        }
        return parentFile;
    }

    public static boolean deleteFile(String destFile) {
        return FileHelper.deleteFile(new File(destFile));
    }

    public static boolean deleteFile(File destFile) {
        if (destFile == null) {
            return false;
        }
        try {
            return FileHelper.deleteFile(destFile.toPath());
        }
        catch (IOException ex) {
            throw new FrameworkException("File Delete Error: ", ex);
        }
    }

    public static boolean deleteFile(Path destFilePath) throws IOException {
        if (destFilePath == null) {
            return false;
        }
        if (!Files.exists(destFilePath, new LinkOption[0])) {
            return false;
        }
        Files.walkFileTree(destFilePath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
        return true;
    }
}

