/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tfw.backend.core.helper.io.file;

import com.tongtech.tfw.backend.core.helper.CharsetHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.io.FileHelper;
import com.tongtech.tfw.backend.core.helper.io.IoHelper;
import com.tongtech.tfw.backend.core.models.exceptions.FrameworkException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;

public class FileOperator
implements Serializable {
    private static final long serialVersionUID = -2501353655694075987L;
    private final File file;
    private final Charset charset;

    public FileOperator(File file) {
        this(file, CharsetHelper.CHARSET_UTF_8);
    }

    public FileOperator(File file, Charset charset) {
        this.file = file;
        this.charset = charset;
    }

    public byte[] readBytes() throws FrameworkException {
        long len = this.file.length();
        if (len >= Integer.MAX_VALUE) {
            throw new FrameworkException("File is larger then max array size");
        }
        byte[] bytes = new byte[(int)len];
        FileInputStream in = null;
        try {
            in = new FileInputStream(this.file);
            int readLength = in.read(bytes);
            if ((long)readLength < len) {
                throw new IOException(StringHelper.format("File length is [{}] but read [{}]!", len, readLength));
            }
        }
        catch (Exception e) {
            try {
                throw new FrameworkException(e);
            }
            catch (Throwable throwable) {
                IoHelper.close(in);
                throw throwable;
            }
        }
        IoHelper.close(in);
        return bytes;
    }

    public File write(byte[] data, int off, int len, boolean isAppend) throws FrameworkException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(FileHelper.touch(this.file), isAppend);
            out.write(data, off, len);
            out.flush();
        }
        catch (IOException e) {
            try {
                throw new FrameworkException(e);
            }
            catch (Throwable throwable) {
                IoHelper.close(out);
                throw throwable;
            }
        }
        IoHelper.close(out);
        return this.file;
    }

    public static FileOperator build(File file) {
        return new FileOperator(file);
    }
}

