/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tfw.backend.core.helper.security;

import com.tongtech.tfw.backend.core.helper.codec.Base64Decoder;
import com.tongtech.tfw.backend.core.helper.codec.Base64Encoder;
import com.tongtech.tfw.backend.core.helper.security.rsa256.RSA256Key;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.HashMap;
import java.util.Map;

public class RSA256Helper {
    public static final String KEY_ALGORITHM = "RSA";
    private static final String PUBLIC_KEY = "RSAPublicKey";
    private static final String PRIVATE_KEY = "RSAPrivateKey";
    private static RSA256Key rsa256Key;

    public static String getPublicKey(Map<String, Object> keyMap) throws Exception {
        Key key = (Key)keyMap.get(PUBLIC_KEY);
        return RSA256Helper.encryptBASE64(key.getEncoded());
    }

    public static String getPublicKey(RSA256Key rsa256Key) throws Exception {
        RSAPublicKey key = rsa256Key.getRsaPublicKey();
        return RSA256Helper.encryptBASE64(key.getEncoded());
    }

    public static String getPrivateKey(Map<String, Object> keyMap) throws Exception {
        Key key = (Key)keyMap.get(PRIVATE_KEY);
        return RSA256Helper.encryptBASE64(key.getEncoded());
    }

    public static String getPrivateKey(RSA256Key rsa256Key) throws Exception {
        RSAPrivateKey key = rsa256Key.getRsaPrivateKey();
        return RSA256Helper.encryptBASE64(key.getEncoded());
    }

    public static byte[] decryptBASE64(String key) throws Exception {
        return Base64Decoder.decode(key);
    }

    public static String encryptBASE64(byte[] key) throws Exception {
        return Base64Encoder.encode(key);
    }

    public static Map<String, Object> initKey() {
        KeyPairGenerator keyPairGen = null;
        try {
            keyPairGen = KeyPairGenerator.getInstance(KEY_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        keyPairGen.initialize(1024);
        KeyPair keyPair = keyPairGen.generateKeyPair();
        RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
        RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
        HashMap<String, Object> keyMap = new HashMap<String, Object>(2);
        keyMap.put(PUBLIC_KEY, publicKey);
        keyMap.put(PRIVATE_KEY, privateKey);
        return keyMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized RSA256Key getRSA256Key() {
        if (rsa256Key != null) return rsa256Key;
        Class<RSA256Key> clazz = RSA256Key.class;
        synchronized (RSA256Key.class) {
            if (rsa256Key != null) return rsa256Key;
            rsa256Key = new RSA256Key();
            Map<String, Object> map = RSA256Helper.initKey();
            rsa256Key.setRsaPrivateKey((RSAPrivateKey)map.get(PRIVATE_KEY));
            rsa256Key.setRsaPublicKey((RSAPublicKey)map.get(PUBLIC_KEY));
            // ** MonitorExit[var0] (shouldn't be in output)
            return rsa256Key;
        }
    }
}

