/*
 * Decompiled with CFR 0.152.
 */
package com.testor.biz.auth.controller;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.testor.biz.auth.AuthEnumCode;
import com.testor.biz.auth.model.LoginParam;
import com.testor.biz.auth.model.TokenResponse;
import com.testor.biz.auth.model.UserInfoResponse;
import com.testor.biz.auth.service.AuthService;
import com.testor.biz.sys.user.UserHelper;
import com.testor.biz.sys.user.model.domain.SysUser;
import com.testor.biz.sys.user.service.SysUserService;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.constants.enumeration.BaseStatusEnum;
import com.tongtech.tfw.backend.common.jwt.JwtHelper;
import com.tongtech.tfw.backend.common.models.exceptions.ApiException;
import com.tongtech.tfw.backend.common.models.jwt.JwtInfos;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.common.request.RequestUtil;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.time.LocalDateTime;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(value="Auth Controller", tags={"Auth \u6743\u9650\u63a7\u5236"})
@RequestMapping(value={"/auth"})
public class AuthController
extends SuperController {
    private static final Logger log = LoggerFactory.getLogger(AuthController.class);
    @Autowired
    private AuthService authService;
    @Autowired
    private SysUserService sysUserService;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ApiOperation(value="\u7528\u6237\u767b\u5f55", notes="User Login \u7528\u6237\u767b\u5f55")
    @PostMapping(value={"/login"})
    public BaseResponse<TokenResponse> login(@RequestBody LoginParam loginParam) {
        BaseResponse baseResponse = new BaseResponse();
        String loginName = loginParam.getLoginname();
        String password = UserHelper.userPassword(loginParam.getPassword());
        if (!StringHelper.isNotEmpty((CharSequence)loginName) || !StringHelper.isNotEmpty((CharSequence)password)) throw new ApiException(AuthEnumCode.USERNAME.transform());
        SysUser sysUser = this.authService.login(loginName);
        if (!ObjectHelper.isNotEmpty((Object)((Object)sysUser))) throw new ApiException(AuthEnumCode.USERNAME.transform());
        if (!password.equals(sysUser.getLoginPwd())) {
            throw new ApiException(AuthEnumCode.PASSWORD.transform());
        }
        if (!"0".equals(sysUser.getStatus())) {
            throw new ApiException(AuthEnumCode.STATUS.transform());
        }
        UserInfoResponse userInfoResponse = this.authService.getUserInfo(sysUser.getUserId());
        String jwt = JwtHelper.issueJwtAuth0((String)IdHelper.getId32bit(), (String)sysUser.getUserId(), (String)JSON.toJSONString((Object)userInfoResponse.getUserInfo()), (String)"Token Issuer", (String)"", (Long)36000L);
        baseResponse.setData((Object)TokenResponse.builder().token(jwt).expired(36000L).build());
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.sysUserService.lambdaUpdate().set(SysUser::getLoginDate, (Object)LocalDateTime.now())).set(SysUser::getLoginIp, (Object)RequestUtil.getIpAddr((HttpServletRequest)RequestUtil.getRequest()))).eq(SysUser::getUserId, (Object)sysUser.getUserId())).update();
        return baseResponse;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ApiOperation(value="\u7528\u6237KEY\u767b\u5f55", notes="\u7528\u6237KEY\u767b\u5f55 User key Login")
    @PostMapping(value={"/keyLogin"})
    public BaseResponse<TokenResponse> keyLogin(@RequestBody LoginParam loginParam) {
        BaseResponse baseResponse = new BaseResponse();
        String loginName = loginParam.getLoginname();
        String password = loginParam.getPassword();
        if (!StringHelper.isNotEmpty((CharSequence)loginName) || !StringHelper.isNotEmpty((CharSequence)password)) throw new ApiException(AuthEnumCode.USERNAME.transform());
        SysUser sysUser = this.authService.loginByKey(loginName);
        if (!ObjectHelper.isNotEmpty((Object)((Object)sysUser))) throw new ApiException(AuthEnumCode.USERNAME.transform());
        if (!password.equals(sysUser.getLoginPwd())) {
            throw new ApiException(AuthEnumCode.PASSWORD.transform());
        }
        if (!"0".equals(sysUser.getStatus())) {
            throw new ApiException(AuthEnumCode.STATUS.transform());
        }
        sysUser.setLoginDate(LocalDateTime.now());
        sysUser.setLoginIp(RequestUtil.getIpAddr((HttpServletRequest)RequestUtil.getRequest()));
        this.sysUserService.updateById((Object)sysUser);
        UserInfoResponse userInfoResponse = this.authService.getUserInfo(sysUser.getUserId());
        String jwt = JwtHelper.issueJwtAuth0((String)IdHelper.getId32bit(), (String)sysUser.getUserId(), (String)JSON.toJSONString((Object)userInfoResponse.getUserInfo()), (String)"Token Issuer", (String)"", (Long)36000L);
        baseResponse.setData((Object)TokenResponse.builder().token(jwt).expired(36000L).build());
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.sysUserService.lambdaUpdate().set(SysUser::getLoginDate, (Object)LocalDateTime.now())).set(SysUser::getLoginIp, (Object)RequestUtil.getIpAddr((HttpServletRequest)RequestUtil.getRequest()))).eq(SysUser::getUserId, (Object)sysUser.getUserId())).update();
        return baseResponse;
    }

    @ApiOperation(value="\u5237\u65b0token", notes="\u5237\u65b0token Refresh Token")
    @GetMapping(value={"/refresh"})
    public BaseResponse<TokenResponse> refreshToken() {
        BaseResponse baseResponse = new BaseResponse();
        String token = RequestUtil.getToken((HttpServletRequest)RequestUtil.getRequest());
        JwtInfos jwtInfos = JwtHelper.parseJwtAuth0((String)token, (String)"Token Issuer");
        UserInfoResponse userInfoResponse = this.authService.getUserInfo(jwtInfos.getUserId());
        String jwt = JwtHelper.issueJwtAuth0((String)IdHelper.getId32bit(), (String)jwtInfos.getUserId(), (String)JSON.toJSONString((Object)userInfoResponse.getUserInfo()), (String)"Token Issuer", (String)"", (Long)36000L);
        baseResponse.setData((Object)TokenResponse.builder().token(jwt).expired(36000L).build());
        return baseResponse;
    }

    @ApiOperation(value="\u83b7\u53d6\u767b\u5f55\u7528\u6237\u4fe1\u606f", notes="\u83b7\u53d6\u767b\u5f55\u7528\u6237\u4fe1\u606f User info")
    @GetMapping(value={"/user_info"})
    public BaseResponse<UserInfoResponse> userInfo(HttpServletRequest request, HttpServletResponse response) {
        BaseResponse baseResponse = new BaseResponse();
        String token = RequestUtil.getToken((HttpServletRequest)request);
        if (StringHelper.isNotEmpty((CharSequence)token)) {
            JwtInfos jwtInfos = JwtHelper.parseJwtAuth0((String)token, (String)"Token Issuer");
            String userId = jwtInfos.getUserId();
            UserInfoResponse userInfoResponse = this.authService.getUserInfo(userId);
            baseResponse.setData((Object)userInfoResponse);
            return baseResponse;
        }
        throw new ApiException(BaseStatusEnum.TOKEN_INVALID.transform());
    }
}

